/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HiddenFunctionObject;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import com.gargoylesoftware.htmlunit.javascript.NativeFunctionToStringFunction;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.RecursiveFunctionObject;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptExecutor;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObject;
import com.gargoylesoftware.htmlunit.javascript.host.DateCustom;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.StringCustom;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.intl.Intl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.UniqueTag;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaScriptEngine {
    private static final Log LOG = LogFactory.getLog(JavaScriptEngine.class);
    private final WebClient webClient_;
    private final HtmlUnitContextFactory contextFactory_;
    private final JavaScriptConfiguration jsConfig_;
    private transient ThreadLocal<Boolean> javaScriptRunning_;
    private transient ThreadLocal<List<PostponedAction>> postponedActions_;
    private transient boolean holdPostponedActions_;
    private transient JavaScriptExecutor javaScriptExecutor_;
    public static final String KEY_STARTING_SCOPE = "startingScope";
    public static final String KEY_STARTING_PAGE = "startingPage";

    public JavaScriptEngine(WebClient webClient) {
        this.webClient_ = webClient;
        this.contextFactory_ = new HtmlUnitContextFactory(webClient);
        this.initTransientFields();
        this.jsConfig_ = JavaScriptConfiguration.getInstance(webClient.getBrowserVersion());
    }

    public final WebClient getWebClient() {
        return this.webClient_;
    }

    public HtmlUnitContextFactory getContextFactory() {
        return this.contextFactory_;
    }

    public void initialize(final WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context cx) {
                try {
                    JavaScriptEngine.this.init(webWindow, cx);
                }
                catch (Exception e) {
                    LOG.error("Exception while initializing JavaScript for the page", e);
                    throw new ScriptException(null, (Throwable)e);
                }
                return null;
            }
        };
        this.getContextFactory().call(action);
    }

    public JavaScriptExecutor getJavaScriptExecutor() {
        return this.javaScriptExecutor_;
    }

    private void init(WebWindow webWindow, Context context) throws Exception {
        Scriptable prototype;
        WebClient webClient = webWindow.getWebClient();
        BrowserVersion browserVersion = webClient.getBrowserVersion();
        HashMap<Class<? extends SimpleScriptable>, Scriptable> prototypes = new HashMap<Class<? extends SimpleScriptable>, Scriptable>();
        HashMap<String, Scriptable> prototypesPerJSName = new HashMap<String, Scriptable>();
        Window window = new Window();
        window.setClassName("Window");
        context.initStandardObjects(window);
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_CONSTRUCTOR)) {
            ClassConfiguration windowConfig = this.jsConfig_.getClassConfiguration("Window");
            if (windowConfig.getJsConstructor() != null) {
                RecursiveFunctionObject functionObject = new RecursiveFunctionObject("Window", windowConfig.getJsConstructor(), window);
                ScriptableObject.defineProperty(window, "constructor", functionObject, 7);
            } else {
                this.defineConstructor(browserVersion, window, window, new Window());
            }
        } else {
            this.deleteProperties(window, "constructor");
        }
        this.deleteProperties(window, "java", "javax", "org", "com", "edu", "net", "JavaAdapter", "JavaImporter", "Continuation", "Packages", "getClass");
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_XML)) {
            this.deleteProperties(window, "XML", "XMLList", "Namespace", "QName");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_Iterator)) {
            this.deleteProperties(window, "Iterator", "StopIteration");
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_INTL)) {
            Intl intl = new Intl();
            intl.setParentScope(window);
            window.defineProperty(intl.getClassName(), intl, 2);
            intl.defineProperties(browserVersion);
        }
        FallbackCaller fallbackCaller = new FallbackCaller();
        ScriptableObject.getObjectPrototype(window).setPrototype(fallbackCaller);
        boolean putPrototypeInWindowScope = browserVersion.hasFeature(BrowserVersionFeatures.JS_OBJECT_WITH_PROTOTYPE_PROPERTY_IN_WINDOW_SCOPE);
        for (ClassConfiguration config : this.jsConfig_.getAll()) {
            SimpleScriptable prototype2;
            boolean isWindow = Window.class.getName().equals(config.getHostClass().getName());
            if (isWindow) {
                JavaScriptEngine.configureConstantsPropertiesAndFunctions(config, window, browserVersion);
                prototype2 = JavaScriptEngine.configureClass(config, window, browserVersion);
                prototypesPerJSName.put(config.getClassName(), prototype2);
                continue;
            }
            prototype2 = JavaScriptEngine.configureClass(config, window, browserVersion);
            if (config.isJsObject() && putPrototypeInWindowScope) {
                Page page;
                SimpleScriptable obj = config.getHostClass().newInstance();
                prototype2.defineProperty("__proto__", prototype2, 2);
                obj.defineProperty("prototype", prototype2, 2);
                obj.setParentScope(window);
                obj.setClassName(config.getClassName());
                ScriptableObject.defineProperty(window, obj.getClassName(), obj, 2);
                JavaScriptEngine.configureConstants(config, obj);
                if (obj.getClass() == Element.class && (page = webWindow.getEnclosedPage()) != null && page.isHtmlPage()) {
                    HtmlDivision domNode = new HtmlDivision("", (HtmlPage)page, null);
                    obj.setDomNode(domNode);
                }
            }
            prototypes.put(config.getHostClass(), prototype2);
            prototypesPerJSName.put(config.getClassName(), prototype2);
        }
        for (ClassConfiguration config : this.jsConfig_.getAll()) {
            ScriptableObject constructor;
            Member jsConstructor = config.getJsConstructor();
            String jsClassName = config.getClassName();
            Scriptable prototype3 = (Scriptable)prototypesPerJSName.get(jsClassName);
            String hostClassSimpleName = config.getHostClass().getSimpleName();
            if ("Image".equals(hostClassSimpleName) && browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_PROTOTYPE_SAME_AS_HTML_IMAGE)) {
                prototype3 = (Scriptable)prototypesPerJSName.get("HTMLImageElement");
            }
            if ("Option".equals(hostClassSimpleName) && browserVersion.hasFeature(BrowserVersionFeatures.JS_OPTION_PROTOTYPE_SAME_AS_HTML_OPTION)) {
                prototype3 = (Scriptable)prototypesPerJSName.get("HTMLOptionElement");
            }
            if (prototype3 == null || !config.isJsObject()) continue;
            if (jsConstructor != null) {
                FunctionObject functionObject = "Window".equals(jsClassName) ? (FunctionObject)ScriptableObject.getProperty((Scriptable)window, "constructor") : new RecursiveFunctionObject(jsClassName, jsConstructor, window);
                if ("Image".equals(hostClassSimpleName) || "Option".equals(hostClassSimpleName)) {
                    Object prototypeProperty = ScriptableObject.getProperty((Scriptable)window, prototype3.getClassName());
                    functionObject.addAsConstructor(window, prototype3);
                    ScriptableObject.defineProperty(window, hostClassSimpleName, functionObject, 2);
                    if (!hostClassSimpleName.equals(prototype3.getClassName())) {
                        if (prototypeProperty == UniqueTag.NOT_FOUND) {
                            ScriptableObject.deleteProperty((Scriptable)window, prototype3.getClassName());
                        } else {
                            ScriptableObject.defineProperty(window, prototype3.getClassName(), prototypeProperty, 2);
                        }
                    }
                } else {
                    functionObject.addAsConstructor(window, prototype3);
                }
                JavaScriptEngine.configureConstants(config, functionObject);
                for (Map.Entry<String, Method> staticfunctionInfo : config.getStaticFunctionEntries()) {
                    String functionName = staticfunctionInfo.getKey();
                    Method method = staticfunctionInfo.getValue();
                    FunctionObject staticFunctionObject = new FunctionObject(functionName, method, functionObject);
                    functionObject.defineProperty(functionName, staticFunctionObject, 0);
                }
                continue;
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_CONSTRUCTOR)) {
                if ("Window".equals(jsClassName)) {
                    constructor = (ScriptableObject)ScriptableObject.getProperty((Scriptable)window, "constructor");
                } else {
                    constructor = config.getHostClass().newInstance();
                    ((SimpleScriptable)constructor).setClassName(config.getClassName());
                }
                this.defineConstructor(browserVersion, window, prototype3, constructor);
                JavaScriptEngine.configureConstants(config, constructor);
                continue;
            }
            if (!"Window".equals(jsClassName)) {
                constructor = config.getHostClass().newInstance();
                constructor.setParentScope(window);
                window.defineProperty(constructor.getClassName(), constructor, 2);
            }
            this.deleteProperties(prototype3, "constructor");
        }
        window.setPrototype((Scriptable)prototypesPerJSName.get(Window.class.getSimpleName()));
        Scriptable objectPrototype = ScriptableObject.getObjectPrototype(window);
        for (Map.Entry entry : prototypesPerJSName.entrySet()) {
            String name = (String)entry.getKey();
            ClassConfiguration config = this.jsConfig_.getClassConfiguration(name);
            Scriptable prototype4 = (Scriptable)entry.getValue();
            if (prototype4.getPrototype() != null) {
                prototype4 = prototype4.getPrototype();
            }
            if (!StringUtils.isEmpty(config.getExtendedClassName())) {
                Scriptable parentPrototype = (Scriptable)prototypesPerJSName.get(config.getExtendedClassName());
                prototype4.setPrototype(parentPrototype);
                continue;
            }
            prototype4.setPrototype(objectPrototype);
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_WINDOW_ACTIVEXOBJECT_HIDDEN) && null != (prototype = (Scriptable)prototypesPerJSName.get("ActiveXObject"))) {
            Method jsConstructor = ActiveXObject.class.getDeclaredMethod("jsConstructor", Context.class, Object[].class, Function.class, Boolean.TYPE);
            HiddenFunctionObject functionObject = new HiddenFunctionObject("ActiveXObject", jsConstructor, window);
            functionObject.addAsConstructor(window, prototype);
        }
        this.removePrototypeProperties(window, "String", "equals", "equalsIgnoreCase");
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_TRIM)) {
            this.removePrototypeProperties(window, "String", "trim");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_TRIM_LEFT_RIGHT)) {
            this.removePrototypeProperties(window, "String", "trimLeft");
            this.removePrototypeProperties(window, "String", "trimRight");
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.STRING_CONTAINS)) {
            ScriptableObject stringPrototype = (ScriptableObject)ScriptableObject.getClassPrototype(window, "String");
            stringPrototype.defineFunctionProperties(new String[]{"contains"}, StringCustom.class, 0);
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_FUNCTION_BIND)) {
            this.removePrototypeProperties(window, "Function", "bind");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_ECMA5_FUNCTIONS)) {
            this.removePrototypeProperties(window, "Date", "toISOString", "toJSON");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_DEFINE_GETTER)) {
            this.removePrototypeProperties(window, "Object", "__defineGetter__", "__defineSetter__", "__lookupGetter__", "__lookupSetter__");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_FUNCTION_TOSOURCE)) {
            this.deleteProperties(window, "uneval");
            this.removePrototypeProperties(window, "Object", "toSource");
            this.removePrototypeProperties(window, "Array", "toSource");
            this.removePrototypeProperties(window, "Date", "toSource");
            this.removePrototypeProperties(window, "Function", "toSource");
            this.removePrototypeProperties(window, "Number", "toSource");
            this.removePrototypeProperties(window, "String", "toSource");
        }
        this.deleteProperties(window, "isXMLName");
        NativeFunctionToStringFunction.installFix(window, webClient.getBrowserVersion());
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_ALLOW_CONST_ASSIGNMENT)) {
            this.makeConstWritable(window, "undefined", "NaN", "Infinity");
        }
        ScriptableObject datePrototype = (ScriptableObject)ScriptableObject.getClassPrototype(window, "Date");
        datePrototype.defineFunctionProperties(new String[]{"toLocaleDateString", "toLocaleTimeString"}, DateCustom.class, 2);
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_USE_UTC)) {
            datePrototype.defineFunctionProperties(new String[]{"toUTCString"}, DateCustom.class, 2);
        }
        window.setPrototypes(prototypes, prototypesPerJSName);
        window.initialize(webWindow);
    }

    private void defineConstructor(BrowserVersion browserVersion, Window window, Scriptable prototype, ScriptableObject constructor) {
        constructor.setParentScope(window);
        ScriptableObject constructorValue = browserVersion.hasFeature(BrowserVersionFeatures.JS_CONSTRUCTOR) ? constructor : null;
        ScriptableObject.defineProperty(prototype, "constructor", constructorValue, 7);
        ScriptableObject.defineProperty(constructor, "prototype", prototype, 7);
        window.defineProperty(constructor.getClassName(), constructor, 2);
    }

    private void makeConstWritable(ScriptableObject scope, String ... constNames) {
        for (String name : constNames) {
            Object value = ScriptableObject.getProperty((Scriptable)scope, name);
            ScriptableObject.defineProperty(scope, name, value, 6);
        }
    }

    private void deleteProperties(Scriptable scope, String ... propertiesToDelete) {
        for (String property : propertiesToDelete) {
            scope.delete(property);
        }
    }

    public void definePropertiesInStandardsMode(HtmlPage page) {
        Window window = ((HTMLDocument)page.getScriptObject()).getWindow();
        BrowserVersion browserVersion = window.getBrowserVersion();
        for (ClassConfiguration config : this.jsConfig_.getAll()) {
            String jsClassName = config.getClassName();
            if (!config.isDefinedInStandardsMode()) continue;
            Scriptable prototype = window.getPrototype(jsClassName);
            if ("Window".equals(jsClassName)) {
                this.defineConstructor(browserVersion, window, window, new Window());
                continue;
            }
            if (config.isJsObject()) continue;
            try {
                ScriptableObject constructor = config.getHostClass().newInstance();
                this.defineConstructor(browserVersion, window, prototype, constructor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void removePrototypeProperties(Scriptable scope, String className, String ... properties) {
        ScriptableObject prototype = (ScriptableObject)ScriptableObject.getClassPrototype(scope, className);
        for (String property : properties) {
            prototype.delete(property);
        }
    }

    public static SimpleScriptable configureClass(ClassConfiguration config, Scriptable window, BrowserVersion browserVersion) throws InstantiationException, IllegalAccessException {
        SimpleScriptable prototype = config.getHostClass().newInstance();
        prototype.setParentScope(window);
        prototype.setClassName(config.getClassName());
        JavaScriptEngine.configureConstantsPropertiesAndFunctions(config, prototype, browserVersion);
        return prototype;
    }

    private static void configureConstantsPropertiesAndFunctions(ClassConfiguration config, ScriptableObject scriptable, BrowserVersion browserVersion) {
        JavaScriptEngine.configureConstants(config, scriptable);
        for (Map.Entry<String, ClassConfiguration.PropertyInfo> propertyEntry : config.getPropertyEntries()) {
            String propertyName = propertyEntry.getKey();
            Method readMethod = propertyEntry.getValue().getReadMethod();
            Method writeMethod = propertyEntry.getValue().getWriteMethod();
            int flag = 0;
            if (browserVersion.isChrome() && "cssFloat".equals(propertyName)) {
                flag = 2;
            }
            scriptable.defineProperty(propertyName, null, readMethod, writeMethod, flag);
        }
        int attributes = browserVersion.hasFeature(BrowserVersionFeatures.JS_DONT_ENUM_FUNCTIONS) ? 2 : 0;
        for (Map.Entry<String, Method> functionInfo : config.getFunctionEntries()) {
            String functionName = functionInfo.getKey();
            Method method = functionInfo.getValue();
            FunctionObject functionObject = new FunctionObject(functionName, method, scriptable);
            scriptable.defineProperty(functionName, functionObject, attributes);
        }
    }

    private static void configureConstants(ClassConfiguration config, ScriptableObject scriptable) {
        Class<? extends SimpleScriptable> linkedClass = config.getHostClass();
        for (String constant : config.getConstants()) {
            try {
                Object value = linkedClass.getField(constant).get(null);
                scriptable.defineProperty(constant, value, 5);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError("Cannot get field '" + constant + "' for type: " + config.getHostClass().getName());
            }
        }
    }

    public synchronized void registerWindowAndMaybeStartEventLoop(WebWindow webWindow) {
        if (this.javaScriptExecutor_ == null) {
            this.javaScriptExecutor_ = BackgroundJavaScriptFactory.theFactory().createJavaScriptExecutor(this.webClient_);
        }
        this.javaScriptExecutor_.addWindow(webWindow);
    }

    public int pumpEventLoop(long timeoutMillis) {
        if (this.javaScriptExecutor_ == null) {
            return 0;
        }
        return this.javaScriptExecutor_.pumpEventLoop(timeoutMillis);
    }

    public void shutdown() {
        if (this.javaScriptExecutor_ != null) {
            this.javaScriptExecutor_.shutdown();
            this.javaScriptExecutor_ = null;
        }
        if (this.postponedActions_ != null) {
            this.postponedActions_.remove();
        }
        if (this.javaScriptRunning_ != null) {
            this.javaScriptRunning_.remove();
        }
        this.holdPostponedActions_ = false;
    }

    public Script compile(HtmlPage htmlPage, String sourceCode, final String sourceName, final int startLine) {
        WebAssert.notNull("sourceCode", sourceCode);
        if (LOG.isTraceEnabled()) {
            String newline = System.getProperty("line.separator");
            LOG.trace("Javascript compile " + sourceName + newline + sourceCode + newline);
        }
        Scriptable scope = this.getScope(htmlPage, null);
        final String source = sourceCode;
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            @Override
            public Object doRun(Context cx) {
                return cx.compileString(source, sourceName, startLine, null);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return source;
            }
        };
        return (Script)this.getContextFactory().call(action);
    }

    public Object execute(HtmlPage htmlPage, String sourceCode, String sourceName, int startLine) {
        Script script = this.compile(htmlPage, sourceCode, sourceName, startLine);
        if (script == null) {
            return null;
        }
        return this.execute(htmlPage, script);
    }

    public Object execute(HtmlPage htmlPage, final Script script) {
        final Scriptable scope = this.getScope(htmlPage, null);
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            @Override
            public Object doRun(Context cx) {
                return script.exec(cx, scope);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return null;
            }
        };
        return this.getContextFactory().call(action);
    }

    public Object callFunction(HtmlPage htmlPage, Function javaScriptFunction, Scriptable thisObject, Object[] args, DomNode htmlElement) {
        Scriptable scope = this.getScope(htmlPage, htmlElement);
        return this.callFunction(htmlPage, javaScriptFunction, scope, thisObject, args);
    }

    public Object callFunction(HtmlPage htmlPage, final Function function, final Scriptable scope, final Scriptable thisObject, final Object[] args) {
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            @Override
            public Object doRun(Context cx) {
                if (ScriptRuntime.hasTopCall(cx)) {
                    return function.call(cx, scope, thisObject, args);
                }
                return ScriptRuntime.doTopCall(function, cx, scope, thisObject, args);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return cx.decompileFunction(function, 2);
            }
        };
        return this.getContextFactory().call(action);
    }

    private Scriptable getScope(HtmlPage htmlPage, DomNode htmlElement) {
        if (htmlElement != null) {
            return htmlElement.getScriptObject();
        }
        return (Window)htmlPage.getEnclosingWindow().getScriptObject();
    }

    public boolean isScriptRunning() {
        return Boolean.TRUE.equals(this.javaScriptRunning_.get());
    }

    private void doProcessPostponedActions() {
        this.holdPostponedActions_ = false;
        try {
            this.getWebClient().loadDownloadedResponses();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<PostponedAction> actions2 = this.postponedActions_.get();
        if (actions2 != null) {
            this.postponedActions_.set(null);
            try {
                for (PostponedAction action : actions2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Processing PostponedAction " + action);
                    }
                    if (!action.isStillAlive()) continue;
                    action.execute();
                }
            }
            catch (Exception e) {
                Context.throwAsScriptRuntimeEx(e);
            }
        }
    }

    public void addPostponedAction(PostponedAction action) {
        List<PostponedAction> actions2 = this.postponedActions_.get();
        if (actions2 == null) {
            actions2 = new ArrayList<PostponedAction>();
            this.postponedActions_.set(actions2);
        }
        actions2.add(action);
    }

    protected void handleJavaScriptException(ScriptException scriptException, boolean triggerOnError) {
        JavaScriptErrorListener javaScriptErrorListener;
        Window w;
        WebWindow window;
        HtmlPage page = scriptException.getPage();
        if (triggerOnError && page != null && (window = page.getEnclosingWindow()) != null && (w = (Window)window.getScriptObject()) != null) {
            try {
                w.triggerOnError(scriptException);
            }
            catch (Exception e) {
                this.handleJavaScriptException(new ScriptException(page, e, null), false);
            }
        }
        if ((javaScriptErrorListener = this.getWebClient().getJavaScriptErrorListener()) != null) {
            javaScriptErrorListener.scriptException(page, scriptException);
        }
        if (this.getWebClient().getOptions().isThrowExceptionOnScriptError()) {
            throw scriptException;
        }
        LOG.info("Caught script exception", scriptException);
    }

    public void holdPosponedActions() {
        this.holdPostponedActions_ = true;
    }

    public void processPostponedActions() {
        this.doProcessPostponedActions();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.javaScriptRunning_ = new ThreadLocal();
        this.postponedActions_ = new ThreadLocal();
        this.holdPostponedActions_ = false;
    }

    public Class<? extends SimpleScriptable> getJavaScriptClass(Class<?> c) {
        return this.jsConfig_.getDomJavaScriptMapping().get(c);
    }

    public JavaScriptConfiguration getJavaScriptConfiguration() {
        return this.jsConfig_;
    }

    private static class FallbackCaller
    extends ScriptableObject {
        private static final long serialVersionUID = 5142592186670858001L;

        private FallbackCaller() {
        }

        @Override
        public Object get(String name, Scriptable start) {
            if (start instanceof ScriptableWithFallbackGetter) {
                return ((ScriptableWithFallbackGetter)start).getWithFallback(name);
            }
            return NOT_FOUND;
        }

        @Override
        public String getClassName() {
            return "htmlUnitHelper-fallbackCaller";
        }
    }

    private abstract class HtmlUnitContextAction
    implements ContextAction {
        private final Scriptable scope_;
        private final HtmlPage htmlPage_;

        public HtmlUnitContextAction(Scriptable scope, HtmlPage htmlPage) {
            this.scope_ = scope;
            this.htmlPage_ = htmlPage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Object run(Context cx) {
            Object object;
            Boolean javaScriptAlreadyRunning = (Boolean)JavaScriptEngine.this.javaScriptRunning_.get();
            JavaScriptEngine.this.javaScriptRunning_.set(Boolean.TRUE);
            try {
                Object response;
                Stack<Scriptable> stack = (Stack<Scriptable>)cx.getThreadLocal(JavaScriptEngine.KEY_STARTING_SCOPE);
                if (null == stack) {
                    stack = new Stack<Scriptable>();
                    cx.putThreadLocal(JavaScriptEngine.KEY_STARTING_SCOPE, stack);
                }
                stack.push(this.scope_);
                try {
                    cx.putThreadLocal(JavaScriptEngine.KEY_STARTING_PAGE, this.htmlPage_);
                    object = this.htmlPage_;
                    synchronized (object) {
                        block20: {
                            if (this.htmlPage_ == this.htmlPage_.getEnclosingWindow().getEnclosedPage()) break block20;
                            Object var6_7 = null;
                            return var6_7;
                        }
                        response = this.doRun(cx);
                    }
                }
                finally {
                    stack.pop();
                }
                if (!JavaScriptEngine.this.holdPostponedActions_) {
                    JavaScriptEngine.this.doProcessPostponedActions();
                }
                object = response;
                return object;
            }
            catch (Exception e) {
                JavaScriptEngine.this.handleJavaScriptException(new ScriptException(this.htmlPage_, e, this.getSourceCode(cx)), true);
                Object response = null;
                return response;
            }
            catch (TimeoutError e) {
                JavaScriptErrorListener javaScriptErrorListener = JavaScriptEngine.this.getWebClient().getJavaScriptErrorListener();
                if (javaScriptErrorListener != null) {
                    javaScriptErrorListener.timeoutError(this.htmlPage_, e.getAllowedTime(), e.getExecutionTime());
                }
                if (JavaScriptEngine.this.getWebClient().getOptions().isThrowExceptionOnScriptError()) {
                    throw new RuntimeException(e);
                }
                LOG.info("Caught script timeout error", e);
                object = null;
                return object;
            }
            finally {
                JavaScriptEngine.this.javaScriptRunning_.set(javaScriptAlreadyRunning);
            }
        }

        protected abstract Object doRun(Context var1);

        protected abstract String getSourceCode(Context var1);
    }
}

