/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.FormField;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClasses(value={@JsxClass(domClass=HtmlTextArea.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)}), @JsxClass(domClass=HtmlTextArea.class, isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class HTMLTextAreaElement
extends FormField {
    private static final Pattern NORMALIZE_VALUE_PATTERN = Pattern.compile("([^\\r])\\n");

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public HTMLTextAreaElement() {
    }

    @Override
    public String getType() {
        return "textarea";
    }

    @Override
    public String getValue() {
        String value = ((HtmlTextArea)this.getDomNodeOrDie()).getText();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TEXTAREA_CRNL)) {
            value = NORMALIZE_VALUE_PATTERN.matcher(value).replaceAll("$1\r\n");
        }
        return value;
    }

    @Override
    public void setValue(String value) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setText(value);
    }

    @JsxGetter
    public int getCols() {
        String s2 = this.getDomNodeOrDie().getAttribute("cols");
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException e) {
            return 20;
        }
    }

    @JsxSetter
    public void setCols(String cols) {
        int i;
        try {
            i = Float.valueOf(cols).intValue();
            if (i < 0) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_COLS_NEGATIVE_THROWS_EXCEPTION)) {
                    throw new NumberFormatException("New value for cols '" + cols + "' is smaller than zero.");
                }
                this.getDomNodeOrDie().setAttribute("cols", null);
                return;
            }
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_COLS_THROWS_EXCEPTION)) {
                throw Context.throwAsScriptRuntimeEx(e);
            }
            return;
        }
        this.getDomNodeOrDie().setAttribute("cols", Integer.toString(i));
    }

    @JsxGetter
    public int getRows() {
        String s2 = this.getDomNodeOrDie().getAttribute("rows");
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException e) {
            return 2;
        }
    }

    @JsxSetter
    public void setRows(String rows) {
        int i;
        try {
            i = new Float(rows).intValue();
            if (i < 0) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_ROWS_NEGATIVE_THROWS_EXCEPTION)) {
                    throw new NumberFormatException("New value for rows '" + rows + "' is smaller than zero.");
                }
                this.getDomNodeOrDie().setAttribute("rows", null);
                return;
            }
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_ROWS_THROWS_EXCEPTION)) {
                throw Context.throwAsScriptRuntimeEx(e);
            }
            return;
        }
        this.getDomNodeOrDie().setAttribute("rows", Integer.toString(i));
    }

    @JsxGetter
    public String getDefaultValue() {
        String value = ((HtmlTextArea)this.getDomNodeOrDie()).getDefaultValue();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TEXTAREA_CRNL)) {
            value = NORMALIZE_VALUE_PATTERN.matcher(value).replaceAll("$1\r\n");
        }
        return value;
    }

    @JsxSetter
    public void setDefaultValue(String defaultValue) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setDefaultValue(defaultValue);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public int getTextLength() {
        return this.getValue().length();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getSelectionStart() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).getSelectionStart();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setSelectionStart(int start) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setSelectionStart(start);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getSelectionEnd() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).getSelectionEnd();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setSelectionEnd(int end) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setSelectionEnd(end);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setSelectionRange(int start, int end) {
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
    }

    @JsxFunction
    public void select() {
        ((HtmlTextArea)this.getDomNodeOrDie()).select();
    }

    @JsxGetter
    public boolean getReadOnly() {
        return ((HtmlTextArea)this.getDomNodeOrDie()).isReadOnly();
    }

    @JsxSetter
    public void setReadOnly(boolean readOnly) {
        ((HtmlTextArea)this.getDomNodeOrDie()).setReadOnly(readOnly);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public String getDataFld() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public void setDataFld(String dataFld) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public String getDataFormatAs() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public void setDataFormatAs(String dataFormatAs) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public String getDataSrc() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})
    public void setDataSrc(String dataSrc) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter
    public Object getMaxLength() {
        String maxLength = this.getDomNodeOrDie().getAttribute("maxLength");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == maxLength && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_GET_MAXLENGTH_UNDEFINED)) {
            return Undefined.instance;
        }
        try {
            return Integer.parseInt(maxLength);
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_GET_MAXLENGTH_MAX_INT)) {
                return Integer.MAX_VALUE;
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_GET_MAXLENGTH_UNDEFINED)) {
                return maxLength;
            }
            return -1;
        }
    }

    @JsxSetter
    public void setMaxLength(String maxLength) {
        try {
            int i = Integer.parseInt(maxLength);
            if (i < 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_SET_MAXLENGTH_NEGATIVE_THROWS_EXCEPTION)) {
                throw Context.throwAsScriptRuntimeEx(new NumberFormatException("New value for maxLength '" + maxLength + "' is smaller than zero."));
            }
            this.getDomNodeOrDie().setAttribute("maxLength", maxLength);
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TEXT_AREA_GET_MAXLENGTH_UNDEFINED)) {
                this.getDomNodeOrDie().setAttribute("maxLength", maxLength);
                return;
            }
            this.getDomNodeOrDie().setAttribute("maxLength", "0");
            return;
        }
    }
}

