/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.multipart;

import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;

public class FileItemPartAdapter
implements Request.Part {
    private final FileItem fileItem;
    public static final Function<FileItem, Request.Part> TO_PARTS = new Function<FileItem, Request.Part>(){

        @Override
        public Request.Part apply(FileItem fileItem) {
            return new FileItemPartAdapter(fileItem);
        }
    };

    public FileItemPartAdapter(FileItem fileItem) {
        this.fileItem = fileItem;
    }

    @Override
    public String getName() {
        return this.fileItem.getFieldName();
    }

    @Override
    public HttpHeader getHeader(String name) {
        Iterator<String> headerValues = this.fileItem.getHeaders().getHeaders(name);
        return new HttpHeader(name, Iterators.toArray(headerValues, String.class));
    }

    @Override
    public HttpHeaders getHeaders() {
        FileItemHeaders headers = this.fileItem.getHeaders();
        Iterator<String> i = headers.getHeaderNames();
        ImmutableList.Builder builder = ImmutableList.builder();
        while (i.hasNext()) {
            String name = i.next();
            builder.add(this.getHeader(name));
        }
        return new HttpHeaders(builder.build());
    }

    @Override
    public Body getBody() {
        return new Body(this.fileItem.get());
    }
}

