/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webbitserver.WebSocket;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.WebSocketHandler;

public class ReconnectingWebSocketHandler
implements WebSocketHandler {
    private final WebSocketHandler handler;
    private final WebSocket webSocket;
    private final long reconnectIntervalMillis;
    private final Timer timer = new Timer();
    private final AtomicBoolean connected = new AtomicBoolean(false);

    public ReconnectingWebSocketHandler(WebSocketHandler handler, WebSocket webSocket, long reconnectIntervalMillis) {
        this.handler = handler;
        this.webSocket = webSocket;
        this.reconnectIntervalMillis = reconnectIntervalMillis;
    }

    @Override
    public void onOpen(WebSocketConnection connection) throws Throwable {
        this.handler.onOpen(connection);
    }

    @Override
    public void onClose(WebSocketConnection connection) throws Throwable {
        this.handler.onClose(connection);
        this.scheduleReconnect();
    }

    @Override
    public void onMessage(WebSocketConnection connection, String msg) throws Throwable {
        this.handler.onMessage(connection, msg);
    }

    @Override
    public void onMessage(WebSocketConnection connection, byte[] msg) throws Throwable {
        this.handler.onMessage(connection, msg);
    }

    @Override
    public void onPing(WebSocketConnection connection, byte[] msg) throws Throwable {
        this.handler.onPing(connection, msg);
    }

    @Override
    public void onPong(WebSocketConnection connection, byte[] msg) throws Throwable {
        this.handler.onPong(connection, msg);
    }

    private void scheduleReconnect() {
        this.connected.set(false);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!ReconnectingWebSocketHandler.this.connected.get()) {
                    ReconnectingWebSocketHandler.this.webSocket.start();
                }
            }
        }, this.reconnectIntervalMillis);
    }
}

