/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.operation.http;

import com.auto.framework.operation.http.HttpMethods;
import com.auto.framework.operation.http.HttpOpRequest;
import com.auto.framework.operation.http.MimeTypes;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class HttpRequestBuilder {
    private String m_sCookies;
    private String baseUrl;
    private String requestBody = null;
    private MimeTypes eMimeType;
    private HttpMethods eRequestType;
    private List<Header> header = new ArrayList<Header>();
    private String apiName;

    public HttpRequestBuilder withBaseUrl(String sBaseUrl) {
        this.baseUrl = sBaseUrl;
        return this;
    }

    public HttpRequestBuilder addHeader(String key, String value) {
        Header header = new Header();
        header.key = key;
        header.value = value;
        this.header.add(header);
        return this;
    }

    public HttpRequestBuilder withApiName(String apiName) {
        this.apiName = apiName;
        return this;
    }

    public HttpRequestBuilder withRequestBody(String sRequestBody) {
        this.requestBody = sRequestBody;
        return this;
    }

    public HttpRequestBuilder withMimeType(MimeTypes eMimeType) {
        this.eMimeType = eMimeType;
        return this;
    }

    public HttpRequestBuilder withRequestType(HttpMethods eRequestType) {
        this.eRequestType = eRequestType;
        return this;
    }

    public HttpOpRequest build() {
        HttpOpRequest hRequest = new HttpOpRequest(this.baseUrl, this.eRequestType, this.apiName);
        hRequest.setContentType(this.eMimeType.toString());
        if (CollectionUtils.isNotEmpty(this.header)) {
            for (Header $ : this.header) {
                hRequest.setHeader($.key, $.value);
            }
        }
        hRequest.setContent(this.requestBody);
        return hRequest;
    }

    public class Header {
        public String key;
        public String value;
    }
}

