/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.report;

import com.auto.framework.runner.data.ExecutionResult;
import com.auto.framework.runner.job.TestJobResult;
import com.auto.framework.runner.report.AbstractReporter;
import dnl.utils.text.table.TextTable;

public class ConsoleReporter
extends AbstractReporter {
    @Override
    public void accept(ExecutionResult result) {
        try {
            System.out.println();
            System.out.println();
            System.out.println("\u001b[33m\u001b[1mDetail report\u001b[0m");
            this.printTestDetail(result);
            System.out.println();
            System.out.println();
            System.out.println("\u001b[33m\u001b[1mTest Summary\u001b[0m");
            this.printSummary(result);
            System.out.println();
            System.out.println();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printSummary(ExecutionResult result) {
        Object[][] summaryData = new Object[1][3];
        summaryData[0][0] = result.getSummary().getPass();
        summaryData[0][1] = result.getSummary().getFatal();
        summaryData[0][2] = result.getSummary().getFail();
        TextTable summary = new TextTable(SUMMARY_COLUMN_NAMES, summaryData);
        summary.printTable();
    }

    private void printTestDetail(ExecutionResult result) {
        Object[][] data = new Object[result.getJobResults().size()][DETAIL_COLUMN_NAMES.length];
        for (int i = 0; i < result.getJobResults().size(); ++i) {
            for (int j = 0; j < DETAIL_COLUMN_NAMES.length; ++j) {
                if (DETAIL_COLUMN_NAMES[j].equals("Class")) {
                    data[i][j] = result.getJobResults().get(i).getClassName();
                    continue;
                }
                if (DETAIL_COLUMN_NAMES[j].equals("Test")) {
                    data[i][j] = result.getJobResults().get(i).getName();
                    continue;
                }
                if (DETAIL_COLUMN_NAMES[j].equals("Status")) {
                    data[i][j] = this.getStatus(result.getJobResults().get(i));
                    continue;
                }
                if (!DETAIL_COLUMN_NAMES[j].equals("Message")) continue;
                data[i][j] = result.getJobResults().get(i).getErrorMessage();
            }
        }
        TextTable tt = new TextTable(DETAIL_COLUMN_NAMES, data);
        tt.printTable();
    }

    private String getStatus(TestJobResult result) {
        return result.isPass() ? "\u2714" : "\u2718";
    }
}

