/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.console.progressbar.wrapped;

import com.auto.framework.runner.console.progressbar.ProgressBar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

public class ProgressBarWrappedSpliterator<T>
implements Spliterator<T>,
AutoCloseable {
    private Spliterator<T> underlying;
    private ProgressBar pb;
    private Set<Spliterator<T>> openChildren;

    public ProgressBarWrappedSpliterator(Spliterator<T> underlying, ProgressBar pb) {
        this(underlying, pb, Collections.synchronizedSet(new HashSet()));
    }

    private ProgressBarWrappedSpliterator(Spliterator<T> underlying, ProgressBar pb, Set<Spliterator<T>> openChildren) {
        this.underlying = underlying;
        this.pb = pb;
        this.openChildren = openChildren;
        this.openChildren.add(this);
    }

    public ProgressBar getProgressBar() {
        return this.pb;
    }

    @Override
    public void close() {
        this.pb.close();
    }

    private void registerChild(Spliterator<T> child) {
        this.openChildren.add(child);
    }

    private void removeThis() {
        this.openChildren.remove(this);
        if (this.openChildren.size() == 0) {
            this.close();
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean r = this.underlying.tryAdvance(action);
        if (r) {
            this.pb.step();
        } else {
            this.removeThis();
        }
        return r;
    }

    @Override
    public Spliterator<T> trySplit() {
        Spliterator<T> u = this.underlying.trySplit();
        if (u != null) {
            ProgressBarWrappedSpliterator<T> child = new ProgressBarWrappedSpliterator<T>(u, this.pb, this.openChildren);
            this.registerChild(child);
            return child;
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.underlying.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.underlying.characteristics();
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this.underlying.getComparator();
    }
}

