/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.utils;

import com.auto.framework.env.RegressionEnvironment;
import com.auto.framework.reporter.TestReporter;
import java.io.File;
import java.io.FileWriter;
import org.apache.log4j.Logger;

public class TestContentFileDumper {
    protected static final Logger logger = Logger.getLogger(TestContentFileDumper.class);
    public static final TestContentFileDumper instance = new TestContentFileDumper();

    private TestContentFileDumper() {
    }

    public void dumpContent(String content, String extension, String name) {
        if (!RegressionEnvironment.isRegression()) {
            String sFileName = TestReporter.getOutputDir() + File.separator + "content" + File.separator + name + "." + extension;
            this.writeToFile(content, sFileName);
            TestReporter.TRACE(this.formatMessage(name, sFileName));
        } else {
            TestReporter.TRACE(this.formatHeading(name) + content);
        }
    }

    private String formatMessage(String name, String sResultPath) {
        return this.formatHeading(name) + "file://" + sResultPath;
    }

    private String formatHeading(String name) {
        return "\u001b[33m\u001b[1m\ufe5d\ufe61\ufe61\ufe61 content " + name + " dump \ufe61\ufe61\ufe61\ufe5e\u001b[0m ";
    }

    private void writeToFile(String sContent, String sFileName) {
        try {
            FileWriter fFileWriter = new FileWriter(new File(sFileName), true);
            fFileWriter.append(sContent);
            fFileWriter.close();
        }
        catch (Exception e) {
            logger.info((Object)"failed write to file", (Throwable)e);
        }
    }

    public static TestContentFileDumper getInstance() {
        return instance;
    }
}

