/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.operation;

import com.auto.framework.operation.Caller;
import com.auto.framework.operation.OpRequest;
import com.auto.framework.operation.OpResult;
import com.auto.framework.operation.Operation;
import com.google.common.collect.Lists;
import java.util.List;

public class OperationFactory {
    public static final String OK = "Ok";

    public static Operation consumableOp(final Caller caller, final String opName) {
        return new Operation(){
            long startTime;

            @Override
            public void execute() {
                this.startTime = System.currentTimeMillis();
                caller.call();
            }

            @Override
            public OpRequest getRequest() {
                return caller::toString;
            }

            @Override
            public OpResult getResult() {
                return new OpResult(){

                    @Override
                    public int getExitStatus() {
                        return 0;
                    }

                    @Override
                    public List<String> getStdOut() {
                        return null;
                    }

                    @Override
                    public List<String> getStdErr() {
                        return Lists.newArrayList((Object[])new String[]{OperationFactory.OK});
                    }

                    @Override
                    public long getExecutionTime() {
                        return System.currentTimeMillis() - startTime;
                    }

                    @Override
                    public String toStringAsOneLine() {
                        return OperationFactory.OK;
                    }
                };
            }

            @Override
            public boolean shouldRunInBackground() {
                return false;
            }

            @Override
            public String getName() {
                return opName;
            }
        };
    }
}

