/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.operation.http;

import com.auto.framework.operation.Operation;
import com.auto.framework.operation.http.HttpOpRequest;
import com.auto.framework.operation.http.HttpOpResponse;
import com.auto.framework.operation.http.HttpRequestBuilder;
import com.google.common.collect.Lists;
import java.util.Collections;

public abstract class AbstractHttpOperation
implements Operation {
    private HttpOpResponse response;
    private HttpOpRequest request;

    @Override
    public void execute() {
        if (this.shouldRunInBackground()) {
            new Thread(this::executeHttp).start();
        } else {
            this.executeHttp();
        }
    }

    private void executeHttp() {
        long startTime = System.currentTimeMillis();
        try {
            String output;
            this.request = this.getHttpRequestBuilder().build();
            this.request.sendRequest();
            long endTime = System.currentTimeMillis();
            String string = output = this.request.getOutput() == null ? "null" : this.request.getOutput().toString();
            this.response = this.request.getStatusCode() == 200 || this.request.getStatusCode() == 201 || this.request.getStatusCode() == 202 ? new HttpOpResponse(this.request.getStatusCode(), Lists.newArrayList((Object[])new String[]{output}), Collections.emptyList(), endTime - startTime) : new HttpOpResponse(this.request.getStatusCode(), Collections.emptyList(), Lists.newArrayList((Object[])new String[]{output}), endTime - startTime);
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            this.response = new HttpOpResponse(500, Collections.emptyList(), Collections.emptyList(), endTime - startTime);
        }
    }

    @Override
    public HttpOpResponse getResult() {
        return this.response;
    }

    @Override
    public HttpOpRequest getRequest() {
        return this.request;
    }

    protected abstract HttpRequestBuilder getHttpRequestBuilder();
}

