/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.operation.http;

import com.auto.framework.operation.OpRequest;
import com.auto.framework.operation.http.HttpMethods;
import com.auto.framework.operation.http.HttpRequestException;
import com.auto.framework.reporter.TestReporter;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpOpRequest
implements OpRequest {
    private final String name;
    private final HttpURLConnection connection;
    private final CharSequence url;
    private int statusCode;
    private StringBuffer output;
    private String requestBody;

    public HttpOpRequest(CharSequence url, HttpMethods method, String sName, int timeOut) throws HttpRequestException {
        this.name = sName;
        try {
            this.url = url;
            System.setProperty("http.keepAlive", "false");
            this.connection = (HttpURLConnection)new URL(url.toString()).openConnection();
            this.connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:25.0) Gecko/20100101 Firefox/25.0");
            this.connection.setRequestMethod(method.toString());
            this.connection.setConnectTimeout(timeOut);
            this.connection.setReadTimeout(timeOut);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public void setContentType(String sContentType) {
        this.setHeader("Content-Type", sContentType);
    }

    public void setHeader(String sKey, String sValue) {
        this.connection.setRequestProperty(sKey, sValue);
    }

    public HttpOpRequest sendRequest() {
        if (this.requestBody != null) {
            this.writeToOutputStream();
        }
        this.statusCode = this.getResponseCode();
        this.output = this.readInput();
        TestReporter.traceExecution(this);
        return this;
    }

    private void writeToOutputStream() {
        this.connection.setDoOutput(true);
        try {
            DataOutputStream wr = new DataOutputStream(this.connection.getOutputStream());
            wr.writeBytes(this.requestBody);
            wr.flush();
            wr.close();
        }
        catch (Exception e) {
            TestReporter.TRACE(e.getMessage());
        }
    }

    private StringBuffer readInput() {
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response;
        }
        catch (Exception e) {
            TestReporter.TRACE(e.getMessage());
            return null;
        }
    }

    private int getResponseCode() {
        try {
            return this.connection.getResponseCode();
        }
        catch (IOException e) {
            return 409;
        }
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public CharSequence getUrl() {
        return this.url;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public StringBuffer getOutput() {
        return this.output;
    }

    public void setContent(String requestBody) {
        this.requestBody = requestBody;
    }

    @Override
    public String getCommandName() {
        return this.name;
    }

    public String getContent() {
        return this.requestBody;
    }
}

