/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.testlist;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;

public class TestListBuilderHandler {
    private String[] classesPrefix;

    public TestListBuilderHandler(String classesPrefix) {
        this.classesPrefix = classesPrefix.split(":");
    }

    public Collection<String> getAllClasses(String testsDir, String classPath) {
        String[] urls = classPath.split(":");
        LinkedList<String> colClassNames = new LinkedList<String>();
        for (int j = 0; j < urls.length; ++j) {
            String sJarPath = urls[j];
            Collection colClassNamesThis = null;
            colClassNamesThis = sJarPath.endsWith(".jar") ? this.readJar(sJarPath) : this.readDir(sJarPath, sJarPath);
            if (null == colClassNamesThis) continue;
            colClassNames.addAll(colClassNamesThis);
        }
        return this.filterNamesByTestDir(colClassNames, testsDir);
    }

    Collection<String> filterNamesByTestDir(Collection<String> colClassNames, String testsDir) {
        if ("all".equals(testsDir)) {
            return colClassNames;
        }
        ArrayList testDirsResolved = Lists.newArrayList((Iterable)Splitter.on((char)',').omitEmptyStrings().split((CharSequence)testsDir));
        return colClassNames.stream().filter(input -> {
            for (String r : testDirsResolved) {
                if (!input.contains("." + r + ".")) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    private Collection readJar(String sJarPath) {
        LinkedList<String> colClasses = new LinkedList<String>();
        try {
            JarFile jFile = new JarFile(sJarPath);
            Enumeration<JarEntry> jarEntries = jFile.entries();
            while (jarEntries.hasMoreElements()) {
                String name;
                ZipEntry entry = jarEntries.nextElement();
                if (entry.isDirectory() || !this.isPackageMatch(name = entry.getName().replace('/', '.')) || !name.endsWith(".class")) continue;
                name = name.substring(0, name.length() - ".class".length());
                colClasses.add(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return colClasses;
    }

    private Collection readDir(String sPath, String sBaseDir) {
        String name;
        LinkedList<String> colClasses = new LinkedList<String>();
        File f = new File(sPath);
        if (f.isDirectory()) {
            String[] arrFiles = f.list();
            for (int i = 0; i < arrFiles.length; ++i) {
                String sFileName = arrFiles[i];
                if (sFileName.startsWith(".")) continue;
                Collection colSubDirClasses = this.readDir(sPath + "/" + sFileName, sBaseDir);
                colClasses.addAll(colSubDirClasses);
            }
        } else if (f.exists() && (name = sPath).endsWith(".class")) {
            name = name.substring(sBaseDir.length() + 1);
            if (this.isPackageMatch(name = name.replace('/', '.'))) {
                name = name.substring(0, name.length() - ".class".length());
                colClasses.add(name);
            }
        }
        return colClasses;
    }

    private boolean isPackageMatch(String name) {
        for (String prefix : this.classesPrefix) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public Set<Method> getMothods() {
        return new Reflections(new Object[]{this.classesPrefix, new MethodAnnotationsScanner()}).getMethodsAnnotatedWith(Test.class);
    }
}

