/*
 * Decompiled with CFR 0.152.
 */
package com.github.randomcodeorg.ppplugin.ppdefaults;

import com.github.randomcodeorg.ppplugin.PContext;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;

public class ByteCodeHelper {
    private final PContext context;
    private ClassPool classPool;
    private List<ClassPath> classPaths = new ArrayList<ClassPath>();
    private final Map<CtClass, Class<?>> editedClasses = new HashMap();

    public ByteCodeHelper(PContext context) {
        this.context = context;
    }

    private void createClassPool() throws NotFoundException {
        if (this.classPool != null) {
            return;
        }
        this.classPool = new ClassPool(true);
        this.classPaths.add(this.classPool.appendClassPath(this.context.getClassRoot().getAbsolutePath()));
        for (String cp : this.context.getClassPaths()) {
            try {
                ClassPath tmp = this.classPool.appendClassPath(cp);
                this.classPaths.add(tmp);
            }
            catch (NotFoundException e) {
                this.context.getLog().warn((CharSequence)String.format("Could not add class path: %s", cp));
            }
        }
    }

    public static CtMethod findMethod(CtClass clazz, Method m) {
        try {
            Class<?>[] runtimeParameterTyes = m.getParameterTypes();
            for (CtMethod ctMethod : clazz.getDeclaredMethods(m.getName())) {
                CtClass[] parameterTypes = ctMethod.getParameterTypes();
                if (parameterTypes.length != runtimeParameterTyes.length) continue;
                boolean missmatch = false;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (runtimeParameterTyes[i].getName().equals(parameterTypes[i].getName())) continue;
                    missmatch = true;
                    break;
                }
                if (missmatch) continue;
                return ctMethod;
            }
            return null;
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public ClassPool getClassPool() throws NotFoundException {
        if (this.classPool == null) {
            this.createClassPool();
        }
        return this.classPool;
    }

    public boolean edit(CtClass cl, Class<?> runtimeClass) throws IllegalStateException {
        if (this.classPool == null) {
            throw new IllegalStateException("There is no ClassPool for this ByteCodeHelper");
        }
        if (!this.editedClasses.containsKey(cl)) {
            this.editedClasses.put(cl, runtimeClass);
            return true;
        }
        return false;
    }

    public CtField getOrCreateField(CtClass ctClass, String typeName, String fieldPrefix, String visibility, boolean isStatic, boolean isFinal, String initValue) throws CannotCompileException {
        CtField f2;
        for (CtField f2 : ctClass.getDeclaredFields()) {
            if (!f2.getName().startsWith(fieldPrefix)) continue;
            try {
                if (!f2.getType().getName().equals(typeName)) continue;
                return f2;
            }
            catch (NotFoundException e) {
                // empty catch block
            }
        }
        String name = ctClass.makeUniqueName(fieldPrefix);
        String staticV = "";
        if (isStatic) {
            staticV = "static";
        }
        String finalV = "";
        if (isFinal) {
            finalV = "final";
        }
        if (initValue == null || initValue.isEmpty()) {
            f2 = CtField.make((String)String.format("%s %s %s %s %s;", visibility, staticV, finalV, typeName, name), (CtClass)ctClass);
            ctClass.addField(f2);
            return f2;
        }
        f2 = CtField.make((String)String.format("%s %s %s %s %s = %s;", visibility, staticV, finalV, typeName, name, initValue), (CtClass)ctClass);
        ctClass.addField(f2);
        return f2;
    }

    public void commit(boolean continueOnException) throws CannotCompileException, IOException {
        if (this.classPool == null) {
            return;
        }
        ClassPool cp = this.classPool;
        for (CtClass c : this.editedClasses.keySet()) {
            cp.importPackage(c.getPackageName());
            try {
                c.toBytecode(new DataOutputStream(this.context.modify(this.editedClasses.get(c))));
            }
            catch (IOException e) {
                this.handleCompilationException(e, c, continueOnException);
            }
            catch (CannotCompileException e) {
                this.handleCompilationException(e, c, continueOnException);
            }
            catch (Error e) {
                this.handleCompilationException(e, c, continueOnException);
            }
            catch (RuntimeException e) {
                this.handleCompilationException(e, c, continueOnException);
            }
        }
        this.editedClasses.clear();
    }

    public void commit() {
        try {
            this.commit(true);
        }
        catch (CannotCompileException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private <T extends Throwable> void handleCompilationException(T e, CtClass c, boolean continueOnException) throws T {
        if (!continueOnException) {
            throw e;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        this.context.getLog().warn((CharSequence)String.format("Could not compile changes in the class %s. The following exception occured: %s", c.getName(), sw.toString()));
    }

    public void releaseResources() {
        if (this.classPool != null) {
            for (ClassPath cp : this.classPaths) {
                this.classPool.removeClassPath(cp);
            }
            this.classPaths.clear();
        }
    }
}

