/*
 * Decompiled with CFR 0.152.
 */
package com.github.randomcodeorg.ppplugin.ppdefaults.logging;

import com.github.randomcodeorg.ppplugin.ppdefaults.AbstractClassModificationProcessor;
import com.github.randomcodeorg.ppplugin.ppdefaults.ByteCodeHelper;
import com.github.randomcodeorg.ppplugin.ppdefaults.logging.LogLevel;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;

public abstract class AbstractLoggingProcessor
extends AbstractClassModificationProcessor {
    private static final String DEFAULT_LOGGER_TYPE = "org.slf4j.Logger";
    private static final String DEFAULT_LOGGER_PREFIX = "al_";
    private static final String DEFAULT_LOGGER_INITIALIZATION = "org.slf4j.LoggerFactory.getLogger(%s.class);";

    protected String getLogMethodName(LogLevel level) {
        return level.getLevelMethodName();
    }

    protected String getLoggerType() {
        return DEFAULT_LOGGER_TYPE;
    }

    protected String getLoggerFieldPrefix() {
        return DEFAULT_LOGGER_PREFIX;
    }

    protected String getLoggerInitialization(CtClass cl) {
        return String.format(DEFAULT_LOGGER_INITIALIZATION, cl.getSimpleName());
    }

    protected CtField injectLogger(ByteCodeHelper helper, CtClass ctClass) throws CannotCompileException {
        return helper.getOrCreateField(ctClass, this.getLoggerType(), this.getLoggerFieldPrefix(), "private", true, true, this.getLoggerInitialization(ctClass));
    }
}

