/*
 * Decompiled with CFR 0.152.
 */
package com.github.randomcodeorg.ppplugin.ppdefaults;

import com.github.randomcodeorg.ppplugin.PContext;
import com.github.randomcodeorg.ppplugin.PProcessor;
import com.github.randomcodeorg.ppplugin.ppdefaults.ByteCodeHelper;
import java.io.IOException;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public abstract class AbstractClassModificationProcessor
implements PProcessor {
    protected PContext context;

    public void init(PContext context) {
        this.context = context;
    }

    public void run(PContext context) {
        try {
            this.doRun();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() throws NotFoundException {
        ByteCodeHelper bch = new ByteCodeHelper(this.context);
        try {
            this.context.getLog().info("Processing compiled classes...");
            ClassPool cp = bch.getClassPool();
            for (Class cl : this.context.getClasses()) {
                CtClass ctClass;
                if (cl.getCanonicalName() == null) continue;
                try {
                    ctClass = cp.get(cl.getCanonicalName());
                }
                catch (NotFoundException e) {
                    this.context.getLog().debug((Throwable)e);
                    this.context.getLog().warn(String.format("The class '%s' could not be loaded by javassist and was skipped. See the debug log for exception details", cl.getCanonicalName()));
                    continue;
                }
                try {
                    this.processClass(bch, ctClass, cl);
                }
                catch (CannotCompileException e) {
                    this.context.getLog().debug((Throwable)e);
                    this.context.getLog().warn(String.format("The changes in '%s' could not be compiled. See the debug log for exception details", cl.getCanonicalName()));
                }
            }
        }
        finally {
            try {
                bch.commit(true);
            }
            catch (CannotCompileException e) {
                this.context.getLog().debug((Throwable)e);
                this.context.getLog().warn("Some changes could not be compiled. See the debug log for exception details");
            }
            catch (IOException e) {
                this.context.getLog().debug((Throwable)e);
                this.context.getLog().warn("Some changes could not be applied. See the debug log for exception details");
            }
            bch.releaseResources();
        }
    }

    protected abstract void processClass(ByteCodeHelper var1, CtClass var2, Class<?> var3) throws CannotCompileException;
}

