/*
 * Decompiled with CFR 0.152.
 */
package com.github.randomcodeorg.ppplugin.ppdefaults.logging;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class AndroidLogAdapter {
    private final String tagName;
    private final Map<String, Method> methodMap = new HashMap<String, Method>();
    private boolean isInitialized = false;
    private static final String LOGGER_CLASS_NAME = "android.util.Log";

    public AndroidLogAdapter(String tagName) {
        this.tagName = tagName;
    }

    private void init() {
        Class<?> logger;
        if (this.isInitialized) {
            return;
        }
        try {
            logger = Class.forName(LOGGER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.findLogMethod(logger, "d");
        this.findLogMethod(logger, "e");
        this.findLogMethod(logger, "i");
        this.findLogMethod(logger, "v");
        this.findLogMethod(logger, "w");
    }

    private void findLogMethod(Class<?> logger, String name) {
        try {
            Method m = logger.getMethod(name, String.class, String.class);
            this.methodMap.put(name, m);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTag(Class<?> runtimeClass) {
        try {
            Field f = runtimeClass.getDeclaredField("TAG");
            if (Modifier.isStatic(f.getModifiers()) && String.class.isAssignableFrom(f.getType())) {
                return (String)f.get(null);
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        String tmp = runtimeClass.getSimpleName();
        if (tmp.length() > 23) {
            tmp = tmp.substring(0, 23);
        }
        return tmp;
    }

    private void callAndroidLogger(String methodName, String message) {
        if (!this.isInitialized) {
            this.init();
        }
        if (!this.methodMap.containsKey(methodName)) {
            throw new IllegalArgumentException();
        }
        Method m = this.methodMap.get(methodName);
        try {
            m.invoke(null, this.tagName, message);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getTag() {
        return this.tagName;
    }

    public void d(String message) {
        this.callAndroidLogger("d", message);
    }

    public void e(String message) {
        this.callAndroidLogger("e", message);
    }

    public void i(String message) {
        this.callAndroidLogger("i", message);
    }

    public void v(String message) {
        this.callAndroidLogger("v", message);
    }

    public void w(String message) {
        this.callAndroidLogger("w", message);
    }
}

