/*
 * Decompiled with CFR 0.152.
 */
package com.github.randomcodeorg.ppplugin.ppdefaults.logging;

import com.github.randomcodeorg.ppplugin.ppdefaults.logging.AndroidLogAdapter;
import com.github.randomcodeorg.ppplugin.ppdefaults.logging.LogLevel;
import com.github.randomcodeorg.ppplugin.ppdefaults.logging.LoggingCodeSource;
import javassist.CtClass;

public class AndroidLoggingCodeSource
implements LoggingCodeSource {
    private Class<? extends AndroidLogAdapter> adapterClass;

    public AndroidLoggingCodeSource(Class<? extends AndroidLogAdapter> adapterClass) {
        this.adapterClass = adapterClass;
    }

    public AndroidLoggingCodeSource() {
        this(AndroidLogAdapter.class);
    }

    @Override
    public String getLogMethodName(LogLevel level) {
        switch (level) {
            case DEBUG: {
                return "d";
            }
            case VERBOSE: {
                return "v";
            }
            case ERROR: {
                return "e";
            }
            case INFORMATION: {
                return "i";
            }
            case WARNING: {
                return "w";
            }
        }
        return "i";
    }

    @Override
    public String getLoggerType() {
        return this.adapterClass.getCanonicalName();
    }

    @Override
    public String getLoggerFieldPrefix() {
        return "al_";
    }

    @Override
    public String getLoggerInitialization(CtClass cl, Class<?> runtimeClass) {
        return String.format("new %s(\"%s\")", this.adapterClass.getCanonicalName(), AndroidLogAdapter.getTag(runtimeClass));
    }
}

