/*
 * Decompiled with CFR 0.152.
 */
package com.github.randomcodeorg.ppplugin.ppdefaults.logging;

import com.github.randomcodeorg.ppplugin.ppdefaults.ByteCodeHelper;
import com.github.randomcodeorg.ppplugin.ppdefaults.logging.AbstractLoggingProcessor;
import com.github.randomcodeorg.ppplugin.ppdefaults.logging.LogLevel;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.expr.ExprEditor;
import javassist.expr.Handler;

public abstract class InsertCaughtExceptionLogProcessor
extends AbstractLoggingProcessor {
    private static final LogLevel DEFAULT_EXCEPTION_LOG_LEVEL = LogLevel.WARNING;

    @Override
    protected void processClass(final ByteCodeHelper helper, CtClass ctClass, final Class<?> runtimeClass) throws CannotCompileException {
        ctClass.instrument(new ExprEditor(){

            public void edit(Handler h) throws CannotCompileException {
                if (h.isFinally()) {
                    return;
                }
                CtClass ctClass = h.getEnclosingClass();
                if (helper.edit(ctClass, runtimeClass)) {
                    InsertCaughtExceptionLogProcessor.this.context.getLog().info(String.format("Inserting a log call for exceptions caught in '%s'", ctClass.getName()));
                }
                CtBehavior ctBehavior = h.where();
                CtField f = InsertCaughtExceptionLogProcessor.this.injectLogger(helper, ctClass, runtimeClass);
                InsertCaughtExceptionLogProcessor.this.context.getLog().debug(String.format("Using logger that is stored in field '%s' to log caught exception at %s:%d", f.getName(), ctBehavior.getLongName(), h.getLineNumber()));
                InsertCaughtExceptionLogProcessor.this.doInsertCatchLog(runtimeClass, h, ctBehavior, f);
            }
        });
    }

    protected void doInsertCatchLog(Class<?> clazz, Handler h, CtBehavior behavior, CtField loggerField) throws CannotCompileException {
        String location = behavior == null ? String.format("%s:%d", h.getEnclosingClass().getSimpleName(), h.getLineNumber()) : String.format("%s:%d", behavior.getLongName(), h.getLineNumber());
        this.context.getLog().info(String.format("Inserting catch log for %s", location));
        String code = String.format("{ %s.%s(\"Caught an \" +  $1.getClass().getCanonicalName() + \" at %s\\n\\tMessage: \" + $1.getMessage() ); }", loggerField.getName(), this.getLogMethodName(this.getExceptionLogLevel(clazz)), location);
        h.insertBefore(code);
    }

    protected LogLevel getExceptionLogLevel(Class<?> enclosingClass) {
        return DEFAULT_EXCEPTION_LOG_LEVEL;
    }
}

