/*
 * Decompiled with CFR 0.152.
 */
package com.github.randomcodeorg.ppplugin.ppdefaults.logging;

import com.github.randomcodeorg.ppplugin.ppdefaults.ByteCodeHelper;
import com.github.randomcodeorg.ppplugin.ppdefaults.logging.AbstractLoggingProcessor;
import com.github.randomcodeorg.ppplugin.ppdefaults.logging.LogThis;
import com.github.randomcodeorg.ppplugin.ppdefaults.logging.Stealth;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;

public class InsertMethodCallLogProcessor
extends AbstractLoggingProcessor {
    @Override
    protected void processClass(ByteCodeHelper helper, CtClass ctClass, Class<?> clazz) throws CannotCompileException {
        this.context.getLog().debug(String.format("Processing class %s...", clazz.getCanonicalName()));
        boolean classLevelLog = clazz.isAnnotationPresent(LogThis.class);
        LogThis annotation = null;
        if (classLevelLog) {
            annotation = clazz.getAnnotation(LogThis.class);
        }
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.isAnnotationPresent(Stealth.class)) continue;
            if (m.isAnnotationPresent(LogThis.class)) {
                this.processMethod(helper, ctClass, clazz, ByteCodeHelper.findMethod(ctClass, m), m, m.getAnnotation(LogThis.class));
                continue;
            }
            if (!classLevelLog) continue;
            this.processMethod(helper, ctClass, clazz, ByteCodeHelper.findMethod(ctClass, m), m, annotation);
        }
    }

    protected void processMethod(ByteCodeHelper helper, CtClass ctClass, Class<?> clazz, CtMethod m, Method runtimeMethod, LogThis annotation) throws CannotCompileException {
        if (m == null) {
            return;
        }
        if (helper.edit(ctClass, clazz)) {
            this.context.getLog().info(String.format("Inserting log calls into %s", m.getLongName()));
        }
        CtField loggerField = this.injectLogger(helper, ctClass, clazz);
        this.context.getLog().debug(String.format("Using logger that is stored in field '%s' to log method calls of %s", loggerField.getName(), m.getLongName()));
        String loggerValue = this.getLoggerMessageString(m, runtimeMethod, annotation, this.getMethodVariableNames(m, runtimeMethod), loggerField);
        String toInsert = String.format("%s.%s(%s);", loggerField.getName(), this.getLogMethodName(annotation.value()), loggerValue);
        this.context.getLog().debug("Inserting: " + toInsert);
        m.insertBefore(toInsert);
    }

    protected String getLoggerMessageString(CtMethod m, Method runtimeMethod, LogThis annotation, String[] parameterNames, CtField loggerField) {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        sb.append("\"Called ");
        sb.append(m.getLongName());
        if (parameterNames.length > 0) {
            sb.append(" with:");
            for (int i = 0; i < parameterNames.length; ++i) {
                String param = parameterNames[i];
                if (param != null) {
                    sb.append(String.format("\\n\\t%s: ", param));
                    sb.append(String.format("\" + $%d + \"", i + 1));
                    continue;
                }
                sb.append(String.format("\\n\\targ%d: ", i));
                sb.append("@Stealth");
            }
        }
        if (annotation.logFields() && (fields = runtimeMethod.getDeclaringClass().getDeclaredFields()).length > 0) {
            if (parameterNames.length == 0) {
                sb.append(" with:");
            } else {
                sb.append("\\n");
            }
            for (Field f : fields) {
                if (f.isAnnotationPresent(Stealth.class) || annotation.ignoreStaticFinal() && Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers())) continue;
                sb.append(String.format("\\n\\t%s [field]: ", f.getName()));
                sb.append(String.format("\" + %s + \"", f.getName()));
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    protected String[] getMethodVariableNames(CtMethod cm, Method method) {
        Parameter[] params = method.getParameters();
        String[] result = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            Parameter p = params[i];
            if (p.isAnnotationPresent(Stealth.class)) continue;
            result[i] = String.format("arg%d", i);
        }
        return result;
    }
}

