/*
 * Decompiled with CFR 0.152.
 */
package com.github.rodrigotm.ciashop.helpers;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.github.rodrigotm.ciashop.helpers.json.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class Json {
    private static final ObjectMapper defaultObjectMapper = JsonUtils.defaultMapper();
    private static volatile ObjectMapper objectMapper = null;

    public static <A> A fromJson(JsonNode json, Class<A> clazz) {
        try {
            return (A)Json.mapper().treeToValue((TreeNode)json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromJson(String jsonString, Class<T> class1) {
        return Json.fromJson(Json.parse(jsonString), class1);
    }

    public static <T> List<T> fromJsonList(String jsonString, Class<T> class1) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = Json.mapper().getTypeFactory().constructCollectionType(List.class, class1);
        return (List)Json.mapper().readValue(jsonString, (JavaType)type);
    }

    private static ObjectMapper mapper() {
        if (objectMapper == null) {
            return defaultObjectMapper;
        }
        return objectMapper;
    }

    public static ObjectNode newObject() {
        return Json.mapper().createObjectNode();
    }

    public static JsonNode parse(InputStream src) {
        try {
            return (JsonNode)Json.mapper().readValue(src, JsonNode.class);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static JsonNode parse(String src) {
        try {
            return (JsonNode)Json.mapper().readValue(src, JsonNode.class);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void setObjectMapper(ObjectMapper mapper) {
        objectMapper = mapper;
    }

    public static String stringify(JsonNode json) {
        return json.toString();
    }

    public static JsonNode toJson(Object data) {
        try {
            return Json.mapper().valueToTree(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(Object object) {
        return Json.toJson(object).toString();
    }
}

