/*
 * Decompiled with CFR 0.152.
 */
package com.github.rodrigotm.ciashop.helpers.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.rodrigotm.ciashop.helpers.json.deserializers.EnumDeserializer;
import com.github.rodrigotm.ciashop.helpers.json.serializers.DateSerializer;
import com.github.rodrigotm.ciashop.helpers.json.serializers.EnumSerializer;
import java.util.Date;

public class JsonUtils {
    public static final ObjectMapper defaultMapper() {
        ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule("EnumModule");
        module.addSerializer(Enum.class, (JsonSerializer)new EnumSerializer());
        module.addDeserializer(Enum.class, (JsonDeserializer)new EnumDeserializer());
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        mapper.registerModule((Module)module);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return mapper;
    }
}

