/*
 * Decompiled with CFR 0.152.
 */
package com.github.rodrigotm.ciashop.helpers.json.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;

public class EnumDeserializer
extends JsonDeserializer<Enum>
implements ContextualDeserializer {
    public static HashMap<String, Object> enumsTypes = new HashMap();

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        enumsTypes.put("EnumType:" + property.getName(), ctxt.getContextualType().getRawClass());
        return this;
    }

    public Enum deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Field[] declaredFields;
        String enumKey = "EnumType:" + p.getCurrentName();
        Class clazz = (Class)enumsTypes.get(enumKey);
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            Object enum_ = Enum.valueOf(clazz, field.getName());
            Field[] _declaredFields = enum_.getClass().getDeclaredFields();
            for (Field _field : declaredFields) {
                if (!_field.getName().equals("value")) continue;
                if (field.getName().equals(p.getText())) {
                    return enum_;
                }
                try {
                    if (!((Integer)_field.get(enum_)).equals(p.getNumberValue())) continue;
                    return enum_;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

