/*
 * Decompiled with CFR 0.152.
 */
package com.github.rodrigotm.ciashop.helpers.request;

import com.github.rodrigotm.ciashop.helpers.Json;
import com.github.rodrigotm.ciashop.helpers.request.CiashopCredentials;
import com.github.rodrigotm.ciashop.helpers.request.RequestContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Future;

public class Request {
    public static HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private HttpRequest request;
    private GenericUrl url;

    public static String createResourceUri(String resource) {
        return Request.path(Request.getEndpoint(), resource);
    }

    public static String getEndpoint() {
        return CiashopCredentials.endpoint;
    }

    public static Request openResource(String resource) throws IOException {
        return new Request(resource);
    }

    public static String path(Object origin, Object ... dest) {
        StringBuffer sb = new StringBuffer(origin.toString());
        for (Object object : dest) {
            sb.append("/" + object);
        }
        return sb.toString();
    }

    public static Request resource() throws IOException {
        return Request.resource("");
    }

    public static Request resource(String resource) throws IOException {
        return new Request(resource);
    }

    private Request(String resource) throws IOException {
        this.url = new GenericUrl(Request.createResourceUri(resource));
        this.request = HTTP_TRANSPORT.createRequestFactory().buildGetRequest(this.url);
        this.auth(this.getToken());
    }

    public Request addParam(String key, Object value) throws IOException {
        this.url.set(key, value);
        return this;
    }

    private String getToken() {
        return CiashopCredentials.bearerToken;
    }

    public Request addParamsFromObject(Object object) throws IOException {
        HashMap hash = Json.fromJson(Json.toJson(object), HashMap.class);
        hash.forEach((k, v) -> this.url.set(k, v));
        return this;
    }

    public Request addHeader(String fieldName, Object value) {
        HttpHeaders h = new HttpHeaders();
        h.set(fieldName, value);
        this.request.setHeaders(h);
        return this;
    }

    public Request auth(String bearerToken) {
        this.request.getHeaders().setAuthorization(bearerToken);
        return this;
    }

    public Request body() {
        this.request.setContent(null);
        return this;
    }

    public Request body(String content) {
        this.request.setContent((HttpContent)new RequestContent(content));
        return this;
    }

    public Request method(String method) {
        this.request.setRequestMethod(method);
        if (method.equals("GET")) {
            this.request.setContent(null);
        }
        return this;
    }

    public Request multipartContentBody(MultipartContent content) {
        this.request.setContent((HttpContent)content);
        return this;
    }

    public HttpResponse send() throws IOException {
        return this.request.execute();
    }

    public Future<HttpResponse> sendAsync() throws IOException {
        return this.request.executeAsync();
    }
}

