/*
 * Decompiled with CFR 0.152.
 */
package com.github.rodrigotm.ciashop.helpers.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.rodrigotm.ciashop.helpers.Json;
import com.github.rodrigotm.ciashop.models.ContentError;

public class RequestError
extends Error {
    private static final long serialVersionUID = 1L;
    private String message = null;
    private ContentError contentError = null;

    public RequestError(int statusCode) {
        if (statusCode == 400) {
            this.message = "Algum par\u00e2metro informado n\u00e3o \u00e9 v\u00e1lido";
        } else if (statusCode == 401) {
            this.message = "API Key da conta n\u00e3o \u00e9 v\u00e1lida";
        } else if (statusCode == 404) {
            this.message = "Objeto n\u00e3o encontrado";
        } else if (statusCode == 408) {
            this.message = "Tempo de resposta do servidor excedeu o limite";
        } else if (statusCode == 409) {
            this.message = "J\u00e1 existe um objeto com esses dados";
        } else if (statusCode == 415) {
            this.message = "Nenhum arquivo foi encontrado na requisi\u00e7\u00e3o";
        } else if (statusCode == 500) {
            this.message = "Erro no processamento";
        }
    }

    public RequestError(JsonNode json) {
        this.contentError = Json.fromJson(json, ContentError.class);
    }

    public RequestError(String message) {
        this.message = message;
    }

    public ContentError getContentError() {
        return this.contentError;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

