/*
 * Decompiled with CFR 0.152.
 */
package com.github.rodrigotm.ciashop.resources;

import com.github.rodrigotm.ciashop.helpers.Json;
import com.github.rodrigotm.ciashop.helpers.request.Request;
import com.github.rodrigotm.ciashop.helpers.request.RequestError;
import com.github.rodrigotm.ciashop.models.Customer;
import com.github.rodrigotm.ciashop.models.filters.CustomerFilter;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import java.util.List;

public class CustomerResource {
    public static final String RESOURCE_V1 = "api/v1/customers";

    public static List<Customer> list(CustomerFilter customerFilter) throws RequestError {
        try {
            Request request = Request.resource(RESOURCE_V1).method("GET").addParamsFromObject(customerFilter);
            HttpResponse response = request.send();
            if (response.isSuccessStatusCode()) {
                return Json.fromJsonList(response.parseAsString(), Customer.class);
            }
            throw new RequestError(response.parseAsString());
        }
        catch (HttpResponseException e) {
            throw new RequestError(Json.parse(e.getContent()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RequestError(e.getMessage());
        }
    }
}

