/*
 * Decompiled with CFR 0.152.
 */
package com.github.rodrigotm.ciashop.resources;

import com.github.rodrigotm.ciashop.helpers.Json;
import com.github.rodrigotm.ciashop.helpers.request.Request;
import com.github.rodrigotm.ciashop.helpers.request.RequestError;
import com.github.rodrigotm.ciashop.models.MetaField;
import com.github.rodrigotm.ciashop.models.Response;
import com.github.rodrigotm.ciashop.models.filters.MetaFieldFilter;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import java.util.List;

public class MetaFieldResource {
    public static final String RESOURCE_V1 = "api/v1/metafields";

    public static Response insert(MetaField metaField) throws RequestError {
        try {
            Request request = Request.resource(RESOURCE_V1).method("POST").body(Json.toString(metaField));
            HttpResponse response = request.send();
            if (response.isSuccessStatusCode()) {
                return Json.fromJson(response.parseAsString(), Response.class);
            }
            throw new RequestError(response.getStatusCode());
        }
        catch (HttpResponseException e) {
            throw new RequestError(Json.parse(e.getContent()));
        }
        catch (Exception e) {
            throw new RequestError(e.getMessage());
        }
    }

    public static List<MetaField> list(MetaFieldFilter metaFieldFilter) throws RequestError {
        try {
            Request request = Request.resource(RESOURCE_V1).method("GET").addParamsFromObject(metaFieldFilter);
            HttpResponse response = request.send();
            if (response.isSuccessStatusCode()) {
                return Json.fromJsonList(response.parseAsString(), MetaField.class);
            }
            throw new RequestError(response.parseAsString());
        }
        catch (HttpResponseException e) {
            throw new RequestError(Json.parse(e.getContent()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RequestError(e.getMessage());
        }
    }
}

