/*
 * Decompiled with CFR 0.152.
 */
package com.github.rodrigotm.ciashop.resources;

import com.github.rodrigotm.ciashop.helpers.Json;
import com.github.rodrigotm.ciashop.helpers.request.Request;
import com.github.rodrigotm.ciashop.helpers.request.RequestError;
import com.github.rodrigotm.ciashop.models.Order;
import com.github.rodrigotm.ciashop.models.Response;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import java.io.IOException;

public class OrdersResource {
    public static final String RESOURCE_V1 = "api/v1/orders";

    public static Response insert(Order order) throws RequestError {
        try {
            Request request = Request.resource(RESOURCE_V1).method("POST").body(Json.toString(order));
            HttpResponse response = request.send();
            if (response.isSuccessStatusCode()) {
                return Json.fromJson(response.parseAsString(), Response.class);
            }
            throw new RequestError(response.getStatusCode());
        }
        catch (HttpResponseException e) {
            throw new RequestError(Json.parse(e.getContent()));
        }
        catch (IOException e) {
            throw new RequestError(e.getMessage());
        }
    }
}

