/*
 * Decompiled with CFR 0.152.
 */
package fr.romaindu35.pufferjavaapi.impl.manager;

import fr.romaindu35.pufferjavaapi.api.exception.PufferException;
import fr.romaindu35.pufferjavaapi.api.models.Deployment;
import fr.romaindu35.pufferjavaapi.api.models.NodeView;
import fr.romaindu35.pufferjavaapi.impl.PufferJavaAPI;
import fr.romaindu35.pufferjavaapi.impl.manager.Manager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class NodesManager
extends Manager {
    public NodesManager(PufferJavaAPI pufferJavaAPI) {
        super(pufferJavaAPI);
    }

    public List<NodeManager> getNodes() throws PufferException {
        ArrayList<NodeManager> nodeManagerList = new ArrayList<NodeManager>();
        this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().getNodes()).forEach(nodeView -> nodeManagerList.add(new NodeManager(this.pufferJavaAPI, (NodeView)nodeView)));
        return nodeManagerList;
    }

    public NodeManager getServerById(String nodeId) throws PufferException {
        return new NodeManager(this.pufferJavaAPI, this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().getNode(nodeId)));
    }

    public NodeManager getServerByName(String nodeName) throws PufferException {
        AtomicReference nodeManager = null;
        this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().getNodes()).forEach(nodeView -> {
            if (nodeView.getName().equalsIgnoreCase(nodeName)) {
                nodeManager.set(new NodeManager(this.pufferJavaAPI, (NodeView)nodeView));
            }
        });
        return (NodeManager)nodeManager.get();
    }

    public NodeManager createNode(String name, String privateHost, Integer privatePort, String publicHost, Integer publicPort, Integer sftpPort) throws PufferException {
        NodeManager nodeManager = new NodeManager(this.pufferJavaAPI, this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().createNode(new NodeView(0, name, privateHost, privatePort, publicHost, publicPort, sftpPort))));
        this.pufferJavaAPI.logger.info("The node " + nodeManager.getId() + " has been created.");
        return nodeManager;
    }

    public class NodeManager {
        private PufferJavaAPI pufferJavaAPI;
        protected Integer id;
        protected String name;
        protected String privateHost;
        protected Integer privatePort;
        protected String publicHost;
        protected Integer publicPort;
        protected Integer sftpPort;

        NodeManager(PufferJavaAPI pufferJavaAPI, Integer id, String name, String privateHost, Integer privatePort, String publicHost, Integer publicPort, Integer sftpPort) {
            this.id = id;
            this.name = name;
            this.privateHost = privateHost;
            this.privatePort = privatePort;
            this.publicHost = publicHost;
            this.publicPort = publicPort;
            this.sftpPort = sftpPort;
            this.pufferJavaAPI = pufferJavaAPI;
        }

        NodeManager(PufferJavaAPI pufferJavaAPI, NodeView nodeView) {
            this(pufferJavaAPI, nodeView.getId(), nodeView.getName(), nodeView.getPrivateHost(), nodeView.getPrivatePort(), nodeView.getPublicHost(), nodeView.getPublicPort(), nodeView.getSftpPort());
        }

        public void editNode(NodeEditor nodeEditor) throws PufferException {
            NodeView nodeView = new NodeView(this.id, this.name, this.privateHost, this.privatePort, this.publicHost, this.publicPort, this.sftpPort);
            if (nodeEditor.updateName) {
                nodeView.setName(nodeEditor.getName());
            }
            if (nodeEditor.updatePrivateHost) {
                nodeView.setPrivateHost(nodeEditor.getPrivateHost());
            }
            if (nodeEditor.updatePrivatePort) {
                nodeView.setPrivatePort(nodeEditor.getPrivatePort());
            }
            if (nodeEditor.updatePublicHost) {
                nodeView.setPublicHost(nodeEditor.getPublicHost());
            }
            if (nodeEditor.updatePublicPort) {
                nodeView.setPublicPort(nodeEditor.getPublicPort());
            }
            if (nodeEditor.updateSftpPort) {
                nodeView.setSftpPort(nodeEditor.getSftpPort());
            }
            this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().editNode(String.valueOf(this.id), nodeView));
            this.pufferJavaAPI.logger.info("The node " + this.id + " has been edited.");
        }

        public void deleteNode() throws PufferException {
            this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().deleteNode(String.valueOf(this.id)));
            this.pufferJavaAPI.logger.info("The node " + this.id + " has been deleted.");
        }

        public Deployment getNodeDeploy() throws PufferException {
            this.pufferJavaAPI.logger.info("Node deploy for node " + this.id + " has been get.");
            return this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().getNodeDeploy(String.valueOf(this.id)));
        }

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getPrivateHost() {
            return this.privateHost;
        }

        public Integer getPrivatePort() {
            return this.privatePort;
        }

        public String getPublicHost() {
            return this.publicHost;
        }

        public Integer getPublicPort() {
            return this.publicPort;
        }

        public Integer getSftpPort() {
            return this.sftpPort;
        }
    }

    public class NodeEditor {
        private boolean updateName = false;
        private boolean updatePrivateHost = false;
        private boolean updatePrivatePort = false;
        private boolean updatePublicHost = false;
        private boolean updatePublicPort = false;
        private boolean updateSftpPort = false;
        protected Integer id = 0;
        protected String name = "";
        protected String privateHost = "";
        protected Integer privatePort = 0;
        protected String publicHost = "";
        protected Integer publicPort = 0;
        protected Integer sftpPort = 0;

        public NodeEditor editName(String name) {
            this.updateName = true;
            this.name = name;
            return this;
        }

        public NodeEditor editPrivateHost(String privateHost) {
            this.updatePrivateHost = true;
            this.privateHost = privateHost;
            return this;
        }

        public NodeEditor editPrivatePort(Integer privatePort) {
            this.updatePrivatePort = true;
            this.privatePort = privatePort;
            return this;
        }

        public NodeEditor editPublicHost(String publicHost) {
            this.updatePublicHost = true;
            this.publicHost = publicHost;
            return this;
        }

        public NodeEditor editPublicPort(Integer publicPort) {
            this.updatePublicPort = true;
            this.publicPort = publicPort;
            return this;
        }

        public NodeEditor editSftpPort(Integer sftpPort) {
            this.updateSftpPort = true;
            this.sftpPort = sftpPort;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public String getPrivateHost() {
            return this.privateHost;
        }

        public Integer getPrivatePort() {
            return this.privatePort;
        }

        public String getPublicHost() {
            return this.publicHost;
        }

        public Integer getPublicPort() {
            return this.publicPort;
        }

        public Integer getSftpPort() {
            return this.sftpPort;
        }
    }
}

