/*
 * Decompiled with CFR 0.152.
 */
package fr.romaindu35.pufferjavaapi.api.request;

import fr.romaindu35.pufferjavaapi.api.Authentificator;
import fr.romaindu35.pufferjavaapi.api.messages.FileDesc;
import fr.romaindu35.pufferjavaapi.api.models.ChangeSelfSetting;
import fr.romaindu35.pufferjavaapi.api.models.ChangeUserSetting;
import fr.romaindu35.pufferjavaapi.api.models.CreateServerResponse;
import fr.romaindu35.pufferjavaapi.api.models.Deployment;
import fr.romaindu35.pufferjavaapi.api.models.GetServerResponse;
import fr.romaindu35.pufferjavaapi.api.models.NodeView;
import fr.romaindu35.pufferjavaapi.api.models.PermissionView;
import fr.romaindu35.pufferjavaapi.api.models.PufferSession;
import fr.romaindu35.pufferjavaapi.api.models.ServerCreation;
import fr.romaindu35.pufferjavaapi.api.models.ServerSearchResponse;
import fr.romaindu35.pufferjavaapi.api.models.SettingResponse;
import fr.romaindu35.pufferjavaapi.api.models.Template;
import fr.romaindu35.pufferjavaapi.api.models.UserSearchResponse;
import fr.romaindu35.pufferjavaapi.api.models.UserSettingView;
import fr.romaindu35.pufferjavaapi.api.models.UserView;
import fr.romaindu35.pufferjavaapi.api.pufferpanel.PufferdRunning;
import fr.romaindu35.pufferjavaapi.api.pufferpanel.ServerData;
import fr.romaindu35.pufferjavaapi.api.pufferpanel.ServerLogs;
import fr.romaindu35.pufferjavaapi.api.pufferpanel.ServerRunning;
import fr.romaindu35.pufferjavaapi.api.pufferpanel.ServerStats;
import java.io.File;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface Request {
    @POST(value="/auth/login")
    public Call<PufferSession> getSession(@Body Authentificator var1);

    @GET(value="/api/self")
    public Call<UserView> getSelf();

    @PUT(value="/api/self")
    public Call<UserView> updateSelf(@Body ChangeSelfSetting var1);

    @GET(value="/api/nodes")
    public Call<List<NodeView>> getNodes();

    @POST(value="/api/nodes")
    public Call<NodeView> createNode(@Body NodeView var1);

    @GET(value="/api/nodes/{id}")
    public Call<NodeView> getNode(@Path(value="id") String var1);

    @PUT(value="/api/nodes/{id}")
    public Call<Void> editNode(@Path(value="id") String var1, @Body NodeView var2);

    @DELETE(value="/api/nodes/{id}")
    public Call<Void> deleteNode(@Path(value="id") String var1);

    @GET(value="/api/nodes/{id}/deployment")
    public Call<Deployment> getNodeDeploy(@Path(value="id") String var1);

    @GET(value="/api/servers")
    public Call<ServerSearchResponse> getServers();

    @GET(value="/api/servers/{id}")
    public Call<GetServerResponse> getServer(@Path(value="id") String var1);

    @PUT(value="/api/servers/{id}")
    public Call<CreateServerResponse> createServer(@Path(value="id") String var1, @Body ServerCreation var2);

    @DELETE(value="/api/servers/{id}")
    public Call<Void> deleteServer(@Path(value="id") String var1);

    @GET(value="/api/servers/{id}/user")
    public Call<List<PermissionView>> getUserAccessServer(@Path(value="id") String var1);

    @PUT(value="/api/servers/{id}/users/{email}")
    public Call<Void> editUserAccessServerPermission(@Path(value="id") String var1, @Path(value="email") String var2, @Body PermissionView var3);

    @DELETE(value="/api/servers/{id}/users/{email}")
    public Call<Void> deleteUserAccessServer(@Path(value="id") String var1, @Path(value="email") String var2);

    @GET(value="/api/settings/{key}")
    public Call<SettingResponse> getPanelSetting(@Path(value="key") String var1);

    @GET(value="/api/templates")
    public Call<List<Template>> getTemplate();

    @POST(value="/api/templates/import")
    public Call<String> getImportableTemplates(@Body Template var1);

    @POST(value="/api/templates/import/{name}")
    public Call<Void> importTemplateFromRepository(@Path(value="name") String var1);

    @PUT(value="/api/templates/{name}")
    public Call<Void> addOrUpdateTemplate(@Path(value="name") String var1, @Body Template var2);

    @DELETE(value="/api/templates/{name}")
    public Call<Void> deleteTemplate(@Path(value="name") String var1);

    @GET(value="/api/userSettings")
    public Call<List<UserSettingView>> getUserSetting();

    @PUT(value="/api/userSettings/{key}")
    public Call<Void> updateUserSetting(@Path(value="key") String var1, @Body ChangeUserSetting var2);

    @GET(value="/api/users")
    public Call<UserSearchResponse> getUsers();

    @POST(value="/api/users")
    public Call<UserView> createUser(@Body UserView var1);

    @GET(value="/api/users/{id}")
    public Call<UserView> getUser(@Path(value="id") Integer var1);

    @POST(value="/api/users/{id}")
    public Call<Void> updateUser(@Path(value="id") Integer var1, @Body UserView var2);

    @DELETE(value="/api/users/{id}")
    public Call<UserView> deleteUser(@Path(value="id") Integer var1);

    @GET(value="/api/users/{id}/perms")
    public Call<PermissionView> getUserPermissions(@Path(value="id") Integer var1);

    @PUT(value="/api/users/{id}/perms")
    public Call<Void> setUserPermissions(@Path(value="id") Integer var1, @Body PermissionView var2);

    @GET(value="/daemon")
    public Call<PufferdRunning> isDaemonUp();

    @POST(value="/daemon/server/{id}/archive/{filename}")
    public Call<Void> archiveFile(@Path(value="id") String var1, @Path(value="filename") String var2);

    @POST(value="/daemon/server/{id}/console")
    public Call<ServerLogs> getServerLogs(@Path(value="id") String var1);

    @POST(value="/daemon/server/{id}/console")
    public Call<Void> runCommand(@Path(value="id") String var1, @Body String var2);

    @GET(value="/daemon/server/{id}/data")
    public Call<ServerData> getServerData(@Path(value="id") String var1);

    @POST(value="/daemon/server/{id}/data")
    public Call<Void> editServerData(@Path(value="id") String var1, @Body ServerData var2);

    @GET(value="/daemon/server/{id}/extract/{filename}")
    public Call<Void> extractFile(@Path(value="id") String var1, @Path(value="filename") String var2, @Path(value="destination") String var3);

    @GET(value="/daemon/server/{id}/file/{filename}")
    public Call<FileDesc> getFileList(@Path(value="id") String var1, @Path(value="filename") String var2);

    @PUT(value="/daemon/server/{id}/file/{filename}")
    public Call<FileDesc> putFileOrFolder(@Path(value="id") String var1, @Path(value="filename") String var2, @Path(value="folder") boolean var3, @Path(value="file") File var4);

    @DELETE(value="/daemon/server/{id}/file/{filename}")
    public Call<Void> deleteFile(@Path(value="id") String var1, @Path(value="filename") String var2);

    @POST(value="/daemon/server/{id}/install")
    public Call<Void> installServer(@Path(value="id") String var1, @Query(value="wait") boolean var2);

    @POST(value="/daemon/server/{id}/kill")
    public Call<Void> killServer(@Path(value="id") String var1);

    @POST(value="/daemon/server/{id}/reload")
    public Call<Void> reloadServer(@Path(value="id") String var1);

    @POST(value="/daemon/server/{id}/start")
    public Call<Void> startServer(@Path(value="id") String var1, @Query(value="wait") boolean var2);

    @GET(value="/daemon/server/{id}/stats")
    public Call<ServerStats> getServerStats(@Path(value="id") String var1);

    @GET(value="/daemon/server/{id}/status")
    public Call<ServerRunning> getServerStatus(@Path(value="id") String var1);

    @POST(value="/daemon/server/{id}/stop")
    public Call<Void> stopServer(@Path(value="id") String var1, @Query(value="wait") boolean var2);
}

