/*
 * Decompiled with CFR 0.152.
 */
package fr.romaindu35.pufferjavaapi.impl.manager;

import fr.romaindu35.pufferjavaapi.api.exception.PufferException;
import fr.romaindu35.pufferjavaapi.api.models.NodeView;
import fr.romaindu35.pufferjavaapi.api.models.ServerView;
import fr.romaindu35.pufferjavaapi.api.pufferpanel.ServerLogs;
import fr.romaindu35.pufferjavaapi.api.pufferpanel.ServerStats;
import fr.romaindu35.pufferjavaapi.impl.PufferJavaAPI;

public class ServerManager
extends ServerView {
    private PufferJavaAPI pufferJavaAPI;

    ServerManager(PufferJavaAPI pufferJavaAPI, String id, String ip, String name, NodeView node, Integer nodeId, Integer port, String type) {
        super(id, ip, name, node, nodeId, port, type);
        this.pufferJavaAPI = pufferJavaAPI;
    }

    ServerManager(PufferJavaAPI pufferJavaAPI, ServerView serverView) {
        this(pufferJavaAPI, serverView.getId(), serverView.getIp(), serverView.getName(), serverView.getNode(), serverView.getNodeId(), serverView.getPort(), serverView.getType());
    }

    public void delete() throws PufferException {
        this.pufferJavaAPI.logger.info("The server " + this.id + " has been deleted.");
        this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().deleteServer(this.id));
    }

    public ServerLogs getLogs() throws PufferException {
        this.pufferJavaAPI.logger.info("Logs has been get for server " + this.id + ".");
        return this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().getServerLogs(this.id));
    }

    public void start(boolean wait) throws PufferException {
        this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().startServer(this.id, wait));
        if (wait) {
            this.pufferJavaAPI.logger.info("The server " + this.id + " has been started and wait start finish before execute other task.");
        } else {
            this.pufferJavaAPI.logger.info("The server " + this.id + " has been started.");
        }
    }

    public void stop(boolean wait) throws PufferException {
        this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().stopServer(this.id, wait));
        if (wait) {
            this.pufferJavaAPI.logger.info("The server " + this.id + " has been stopped and wait stop finish before execute other task.");
        } else {
            this.pufferJavaAPI.logger.info("The server " + this.id + " has been stopped.");
        }
    }

    public void install(boolean wait) throws PufferException {
        this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().installServer(this.id, wait));
        if (wait) {
            this.pufferJavaAPI.logger.info("The server " + this.id + " has been installed and wait install finish before execute other task.");
        } else {
            this.pufferJavaAPI.logger.info("The server " + this.id + " has been installed.");
        }
    }

    public void reload() throws PufferException {
        this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().reloadServer(this.id));
        this.pufferJavaAPI.logger.info("The server " + this.id + " has been reloaded.");
    }

    public void kill() throws PufferException {
        this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().killServer(this.id));
        this.pufferJavaAPI.logger.info("The server " + this.id + " has been killed.");
    }

    public ServerStats getStats() throws PufferException {
        this.pufferJavaAPI.logger.info("ServerStats has been get for server " + this.id + ".");
        return this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().getServerStats(this.id));
    }

    public boolean getStatus() throws PufferException {
        this.pufferJavaAPI.logger.info("Status has been get for server " + this.id + ".");
        return this.pufferJavaAPI.send(this.pufferJavaAPI.getRequest().getServerStatus(this.id)).isRunning();
    }
}

