/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.OAuth2AccessTokenExtractor;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;

public class StackExchangeApi
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://stackexchange.com/oauth?client_id=%s&redirect_uri=%s";

    protected StackExchangeApi() {
    }

    public static StackExchangeApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getAccessTokenEndpoint() {
        return "https://stackexchange.com/oauth/access_token";
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        String state;
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Must provide a valid url as callback. StackExchange does not support OOB");
        StringBuilder sb = new StringBuilder(String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback())));
        if (config.hasScope()) {
            sb.append('&').append("scope").append('=').append(OAuthEncoder.encode((String)config.getScope()));
        }
        if ((state = config.getState()) != null) {
            sb.append('&').append("state").append('=').append(OAuthEncoder.encode((String)state));
        }
        return sb.toString();
    }

    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return OAuth2AccessTokenExtractor.instance();
    }

    private static class InstanceHolder {
        private static final StackExchangeApi INSTANCE = new StackExchangeApi();

        private InstanceHolder() {
        }
    }
}

