/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuth1RequestToken;

public class LinkedInApi
extends DefaultApi10a {
    private static final String AUTHORIZE_URL = "https://api.linkedin.com/uas/oauth/authenticate?oauth_token=%s";
    private static final String REQUEST_TOKEN_URL = "https://api.linkedin.com/uas/oauth/requestToken";
    private final String scopesAsString;

    protected LinkedInApi() {
        this.scopesAsString = null;
    }

    protected LinkedInApi(String ... scopes) {
        StringBuilder builder = new StringBuilder();
        for (String scope : scopes) {
            builder.append('+').append(scope);
        }
        this.scopesAsString = "?scope=" + builder.substring(1);
    }

    public static LinkedInApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static LinkedInApi instance(String ... scopes) {
        return scopes == null || scopes.length == 0 ? LinkedInApi.instance() : new LinkedInApi(scopes);
    }

    public String getAccessTokenEndpoint() {
        return "https://api.linkedin.com/uas/oauth/accessToken";
    }

    public String getRequestTokenEndpoint() {
        return this.scopesAsString == null ? REQUEST_TOKEN_URL : REQUEST_TOKEN_URL + this.scopesAsString;
    }

    public String getAuthorizationUrl(OAuth1RequestToken requestToken) {
        return String.format(AUTHORIZE_URL, requestToken.getToken());
    }

    private static class InstanceHolder {
        private static final LinkedInApi INSTANCE = new LinkedInApi();

        private InstanceHolder() {
        }
    }
}

