package com.github.shoothzj.javatool.http.async;

import com.github.shoothzj.javatool.util.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public interface HttpCallback {

    Logger log = LoggerFactory.getLogger(HttpCallback.class);

    void handleResponse(int code, Map<String, String> headerMap, String response);

    default void handleException(Exception e) {
        log.error("Exec http request failed, exception is {}", ExceptionUtil.getException(e));
    }

}
