package com.github.shoothzj.javatool.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class PropertyUtil {

    private static final Logger log = LoggerFactory.getLogger(PropertyUtil.class);

    private static final ConcurrentHashMap<String, String> privateMap = new ConcurrentHashMap<>();

    static {
        String s = System.getProperty("user.home") + "/akkaScala.config";
        try {
            Stream<String> lines = Files.lines(Paths.get(s));
            lines.forEach(new Consumer<String>() {
                @Override
                public void accept(String s) {
                    String[] split = s.split(" ");
                    privateMap.put(split[0], split[1]);
                }
            });
        } catch (IOException e) {
            throw new RuntimeException("config File doesn't exist");
        }
    }

    public static String getPrivateConfig(String name) {
        return privateMap.get(name);
    }

}
