package com.github.shoothzj.javatool.http.async;

import com.github.shoothzj.javatool.http.HttpConstant;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URI;

public class AsyncHttpService {

    private static final Logger log = LoggerFactory.getLogger(AsyncHttpService.class);

    static final AsyncHttpPool asyncHttpPool = new AsyncHttpPool(new PoolConfigBuilder().build());

    public static void sendHttpAsyncProxy(HttpUriRequest httpUriRequest, HttpCallback httpCallback) throws Exception {
        URI uri = httpUriRequest.getURI();
        HttpHost httpHost;
        if (uri.getScheme().equalsIgnoreCase("http")) {
            httpHost = new HttpHost(HttpConstant.proxyServerIp, HttpConstant.httpProxyPort);
        } else if (uri.getScheme().equalsIgnoreCase("https")) {
            httpHost = new HttpHost(HttpConstant.proxyServerIp, HttpConstant.httpsProxyPort);
        } else {
            throw new IllegalArgumentException(String.format("Scheme is not legal!, uri is %s", uri));
        }
        httpUriRequest.setHeader("Cookie", "I am a Cookie");
        asyncHttpPool.sendHttpAsyncProxy(httpHost, httpUriRequest, httpCallback);
    }


}
