package com.github.shoothzj.javatool.http.async;

public class PoolConfigBuilder {

    int tcpConnectTimeout;

    int socketTimeout;

    int maxConnects;

    int maxConnectPerRoute;

    public PoolConfigBuilder() {
        this.tcpConnectTimeout = 5;
        this.socketTimeout = 15;
        this.maxConnects = 12000;
        this.maxConnectPerRoute = 1000;
    }

    public PoolConfigBuilder tcpConnectTimeout(int tcpConnectionTimeout) {
        this.tcpConnectTimeout = tcpConnectionTimeout;
        return this;
    }

    public PoolConfigBuilder socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public PoolConfigBuilder maxConnects(int maxConnects) {
        this.maxConnects = maxConnects;
        return this;
    }

    public PoolConfigBuilder maxConnectPerRoute(int maxConnectPerRoute) {
        this.maxConnectPerRoute = maxConnectPerRoute;
        return this;
    }

    public PoolConfig build() {
        return new PoolConfig(tcpConnectTimeout, socketTimeout, maxConnects, maxConnectPerRoute);
    }

}
