package com.github.shoothzj.javatool.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class JacksonService {

    private static final Logger log = LoggerFactory.getLogger(JacksonService.class);

    private static final ObjectMapper mapper = new ObjectMapper();

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
    }

    public static String toJson(Object o) {
        try {
            return mapper.writeValueAsString(o);
        } catch (JsonProcessingException e) {
            log.error("json process error, exception is {}", e);
        }
        return "";
    }

    public static <T> T toObject(String json, Class<T> type) {
        try {
            mapper.readValue(json, type);
        } catch (IOException e) {
            log.error("json process error, exception is {}", e);
        }
        return null;
    }

}
