/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.test.http.server;

import com.github.shoothzj.javatool.test.http.server.TestProxyHttpHandler;
import com.github.shoothzj.javatool.test.http.server.verifier.HttpResponseProvider;
import com.github.shoothzj.javatool.util.ExceptionUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProxyHttpServer {
    private static final Logger log = LoggerFactory.getLogger(TestProxyHttpServer.class);
    private final Executor executor = Executors.newSingleThreadExecutor();
    private volatile HttpResponseProvider httpResponseProvider;
    private final Object object = new Object();
    private volatile FullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);

    public TestProxyHttpServer() throws InterruptedException {
        this(null);
    }

    public TestProxyHttpServer(HttpResponseProvider httpResponseProvider) throws InterruptedException {
        this.httpResponseProvider = httpResponseProvider;
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(1);
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
                ch.pipeline().addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                ch.pipeline().addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
                ch.pipeline().addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
                ch.pipeline().addLast("business", (ChannelHandler)new TestProxyHttpHandler(TestProxyHttpServer.this));
            }
        });
        ChannelFuture cf = b.bind("0.0.0.0", 10297);
        cf.sync();
        this.executor.execute(() -> TestProxyHttpServer.lambda$new$0(cf, (EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHttpResponse(FullHttpResponse defaultHttpResponse) {
        Object object = this.object;
        synchronized (object) {
            this.response = defaultHttpResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHttpResponseProvider(HttpResponseProvider httpResponseProvider) {
        Object object = this.object;
        synchronized (object) {
            this.httpResponseProvider = httpResponseProvider;
        }
    }

    protected FullHttpResponse askForResponse(String url, Map<String, String> header, String content) {
        Optional<FullHttpResponse> response;
        if (this.httpResponseProvider != null && (response = this.httpResponseProvider.response(url, header, content)).isPresent()) {
            return response.get();
        }
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$new$0(ChannelFuture cf, EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        try {
            cf.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            log.error("Executor close exception, exception is {}", (Object)ExceptionUtil.getException(e));
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }
}

