package com.github.shoothzj.javatool.http.sync;

import com.github.shoothzj.javatool.http.HttpAkResponse;
import com.github.shoothzj.javatool.http.PoolConfigBuilder;
import com.github.shoothzj.javatool.tool.PropertyTool;
import com.github.shoothzj.javatool.util.ExceptionUtil;
import com.github.shoothzj.javatool.util.HttpUtil;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

import static com.github.shoothzj.javatool.constant.ToolConfigConstant.*;

public class SyncHttpService {

    private static final Logger log = LoggerFactory.getLogger(SyncHttpService.class);

    static final SyncHttpPool syncHttpPool;

    static {
        PoolConfigBuilder poolConfigBuilder = new PoolConfigBuilder();
        Integer tcpTimeout = PropertyTool.readInt(HTTP_SYNC_TCP_CONN_TIMEOUT);
        Integer socketTimeout = PropertyTool.readInt(HTTP_SYNC_SOCKET_TIMEOUT);
        Integer maxConnect = PropertyTool.readInt(HTTP_SYNC_MAX_CONNECTS);
        Integer connectPerRoute = PropertyTool.readInt(HTTP_SYNC_MAX_CONNECT_PER_ROUTE);
        if (tcpTimeout != null) {
            poolConfigBuilder.tcpConnectTimeout(tcpTimeout);
        }
        if (socketTimeout != null) {
            poolConfigBuilder.socketTimeout(socketTimeout);
        }
        if (maxConnect != null) {
            poolConfigBuilder.maxConnects(maxConnect);
        }
        if (connectPerRoute != null) {
            poolConfigBuilder.maxConnectPerRoute(connectPerRoute);
        }
        syncHttpPool = new SyncHttpPool(poolConfigBuilder.build());
    }

    public static Optional<HttpAkResponse> sendHttpRequest(HttpUriRequest httpUriRequest) {
        try {
            CloseableHttpResponse httpResponse = syncHttpPool.send(httpUriRequest);
            HttpAkResponse akResponse = new HttpAkResponse();
            akResponse.setCode(httpResponse.getStatusLine().getStatusCode());
            akResponse.setHeaderMap(HttpUtil.convert(httpResponse.getAllHeaders()));
            akResponse.setResponse(EntityUtils.toString(httpResponse.getEntity()));
            return Optional.of(akResponse);
        } catch (Exception e) {
            log.error("http execute error, exception is {}", ExceptionUtil.getException(e));
        }
        return Optional.empty();
    }

}
