package com.github.shoothzj.javatool.test.http.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class TestHttpServer {

    private static final Logger log = LoggerFactory.getLogger(TestHttpServer.class);

    private final Executor executor = Executors.newSingleThreadExecutor();

    public TestHttpServer(String host, int port) throws Exception {
        executor.execute(() -> {
            EventLoopGroup bossGroup = new NioEventLoopGroup();
            EventLoopGroup workerGroup = new NioEventLoopGroup();
            try {
                ServerBootstrap b = new ServerBootstrap();
                b.group(bossGroup, workerGroup)
                        .channel(NioServerSocketChannel.class)
                        .childHandler(new ChannelInitializer<SocketChannel>() {
                            @Override
                            protected void initChannel(SocketChannel ch) throws Exception {
                                ch.pipeline().addLast("http-decoder", new HttpRequestDecoder());
                                ch.pipeline().addLast("http-aggregator", new HttpObjectAggregator(65536));
                                ch.pipeline().addLast("http-encoder", new HttpResponseEncoder());
                                ch.pipeline().addLast("http-chunked", new ChunkedWriteHandler());
                                ch.pipeline().addLast("business", new TestHttpHandler());
                            }
                        });
                ChannelFuture cf = b.bind(host, port);
                cf.channel().closeFuture().sync();
            } catch (InterruptedException e) {
                e.printStackTrace();
            } finally {
                bossGroup.shutdownGracefully();
                workerGroup.shutdownGracefully();
            }
        });
    }

}
