package com.github.shoothzj.javatool.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellUtil {

    private static final Logger log = LoggerFactory.getLogger(ShellUtil.class);

    public static boolean executeShellCheckRet(String cmd) {
        if (StringUtils.isEmpty(cmd)) {
            log.error("command is empty.");
            return false;
        }
        try {
            Process pid = Runtime.getRuntime().exec(cmd);
            int ret = pid.waitFor();
            if (ret == 0) {
                return true;
            } else {
                log.error("command is {}, result is {}", cmd, ret);
            }
        } catch (Exception e) {
            log.error("Execute command exception.", e);
        }
        return false;
    }

}
