package com.github.shoothzj.javatool.test.http.server;

import com.github.shoothzj.javatool.util.HttpUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.Charset;

public class TestProxyHttpHandler extends SimpleChannelInboundHandler<FullHttpRequest> {

    private static final Logger log = LoggerFactory.getLogger(TestHttpHandler.class);

    private TestProxyHttpServer server;

    public TestProxyHttpHandler(TestProxyHttpServer server) {
        this.server = server;
    }

    @Override
    protected void messageReceived(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        if (!msg.decoderResult().isSuccess()) {
            log.error("http decode fail {}", msg.decoderResult().cause());
            return;
        }
        HttpMethod method = msg.method();
        HttpHeaders headers = msg.headers();
        ByteBuf byteBuf = msg.content();
        String string = byteBuf.toString(Charset.forName("utf-8"));
        log.info("Receive a http request, method is {}, header is {}, content is {}", method, headers, string);
        ctx.writeAndFlush(server.askForResponse(msg.uri(), HttpUtil.convert(headers), string)).addListener(ChannelFutureListener.CLOSE);
    }

}
