package com.github.shoothzj.javatool.http.async;

import com.github.shoothzj.javatool.http.HttpConstant;
import com.github.shoothzj.javatool.http.PoolConfigBuilder;
import com.github.shoothzj.javatool.util.PropertyUtil;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URI;

import static com.github.shoothzj.javatool.constant.ToolConfigConstant.HTTP_ASYNC_MAX_CONNECTS;
import static com.github.shoothzj.javatool.constant.ToolConfigConstant.HTTP_ASYNC_MAX_CONNECT_PER_ROUTE;
import static com.github.shoothzj.javatool.constant.ToolConfigConstant.HTTP_ASYNC_SOCKET_TIMEOUT;
import static com.github.shoothzj.javatool.constant.ToolConfigConstant.HTTP_ASYNC_TCP_CONN_TIMEOUT;

public class AsyncHttpService {

    private static final Logger log = LoggerFactory.getLogger(AsyncHttpService.class);

    static final AsyncHttpPool asyncHttpPool;
    
    static {
        PoolConfigBuilder poolConfigBuilder = new PoolConfigBuilder();
        Integer tcpTimeout = PropertyUtil.readInt(HTTP_ASYNC_TCP_CONN_TIMEOUT);
        Integer socketTimeout = PropertyUtil.readInt(HTTP_ASYNC_SOCKET_TIMEOUT);
        Integer maxConnect = PropertyUtil.readInt(HTTP_ASYNC_MAX_CONNECTS);
        Integer connectPerRoute = PropertyUtil.readInt(HTTP_ASYNC_MAX_CONNECT_PER_ROUTE);
        if (tcpTimeout != null) {
            poolConfigBuilder.tcpConnectTimeout(tcpTimeout);
        }
        if (socketTimeout != null) {
            poolConfigBuilder.socketTimeout(socketTimeout);
        }
        if (maxConnect != null) {
            poolConfigBuilder.maxConnects(maxConnect);
        }
        if (connectPerRoute != null) {
            poolConfigBuilder.maxConnectPerRoute(connectPerRoute);
        }
        asyncHttpPool = new AsyncHttpPool(poolConfigBuilder.build());
    }

    public static void sendHttpAsyncProxy(HttpUriRequest httpUriRequest, HttpCallback httpCallback) throws Exception {
        URI uri = httpUriRequest.getURI();
        HttpHost httpHost;
        if (uri.getScheme().equalsIgnoreCase("http")) {
            httpHost = new HttpHost(HttpConstant.proxyServerIp, HttpConstant.httpProxyPort);
        } else if (uri.getScheme().equalsIgnoreCase("https")) {
            httpHost = new HttpHost(HttpConstant.proxyServerIp, HttpConstant.httpsProxyPort);
        } else {
            throw new IllegalArgumentException(String.format("Scheme is not legal!, uri is %s", uri));
        }
        httpUriRequest.setHeader("Cookie", "I am a Cookie");
        asyncHttpPool.sendHttpAsyncProxy(httpHost, httpUriRequest, httpCallback);
    }


}
