package com.github.shoothzj.javatool.http.async.handler;

import com.github.shoothzj.javatool.http.async.HttpCallback;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class BasicHandler implements FutureCallback<HttpResponse> {

    private static final Logger log = LoggerFactory.getLogger(BasicHandler.class);

    private final Executor executor;

    private final HttpCallback httpCallback;

    public BasicHandler(Executor executor, HttpCallback httpCallback) {
        this.executor = executor;
        this.httpCallback = httpCallback;
    }


    @Override
    public void completed(HttpResponse result) {
        try {
            if (result == null) {
                throw new IllegalArgumentException("Http response is null");
            }
            int statusCode = result.getStatusLine().getStatusCode();
            Header[] allHeaders = result.getAllHeaders();
            Map<String, String> aux = new HashMap<>();
            Arrays.stream(allHeaders).forEach(header -> aux.put(header.getName(), header.getValue()));
            String content = EntityUtils.toString(result.getEntity());
            executor.execute(() -> {
                httpCallback.handleResponse(statusCode, aux, content);
            });
        } catch (Exception e) {
            executor.execute(() -> {
                httpCallback.handleException(e);
            });
        }
    }

    @Override
    public void failed(Exception ex) {
        executor.execute(() -> {
            httpCallback.handleException(ex);
        });
    }

    @Override
    public void cancelled() {
        executor.execute(() -> {
            httpCallback.handleException(new IllegalArgumentException("Http request has been canceled"));
        });
    }
}
