package com.github.shoothzj.javatool.util;

import io.netty.handler.codec.http.HttpHeaders;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpUtil {

    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static String attachUrlParam(String baseUrl, String... params) {
        StringBuilder sb = new StringBuilder(baseUrl + "?");
        int length = params.length;
        sb.append(params[0]).append("=").append(params[1]);
        for (int i = 2; i < length; i+=2) {
            sb.append("&");
            sb.append(params[i]).append("=").append(params[i + 1]);
        }
        return sb.toString();
    }

    public static String getUrlRequest(String raw, String... params) {
        StringBuilder sb = new StringBuilder();
        char[] charArray = raw.toCharArray();
        boolean flag = false;
        int count = 0;
        for(char ch: charArray) {
            if (ch == '{') {
                flag = true;
            } else if (ch == '}') {
                flag = false;
                sb.append(params[count++]);
            } else {
                if (!flag) {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static HashMap<String, String> convert(HttpHeaders httpHeaders) {
        List<Map.Entry<CharSequence, CharSequence>> entries = httpHeaders.entries();
        HashMap<String, String> result = new HashMap<>();
        entries.forEach(entry -> result.put(entry.getKey().toString(), entry.getValue().toString()));
        return result;
    }

    public static HashMap<String, String> convert(Header[] httpHeaders) {
        HashMap<String, String> result = new HashMap<>();
        for (Header httpHeader : httpHeaders) {
            result.put(httpHeader.getName(), httpHeader.getValue());
        }
        return result;
    }

}
