/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.util;

import com.github.shoothzj.javatool.util.RegexUtil;
import org.apache.commons.net.util.SubnetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ipv4Util {
    private static final Logger log = LoggerFactory.getLogger(Ipv4Util.class);

    public static boolean isInCidr(String ip, String cidr) {
        SubnetUtils subnetUtils = new SubnetUtils(cidr);
        return subnetUtils.getInfo().isInRange(ip);
    }

    public static String convertIp2Cidr(String ip, String netMask) {
        long num = Ipv4Util.ip2Num(ip);
        int help = 1;
        for (int loop = 32 - Ipv4Util.getPrefixLen(netMask); loop > 0; --loop) {
            num &= (long)(~help);
            help <<= 1;
        }
        return Ipv4Util.num2Ip(num);
    }

    public static String convert2Cidr(String netSeg, String netMask) {
        return netSeg + "/" + Ipv4Util.getPrefixLen(netMask);
    }

    public static int getPrefixLen(String netMask) {
        long num = Ipv4Util.ip2Num(netMask);
        int result = 0;
        while (num % 2L == 0L) {
            num /= 2L;
            ++result;
        }
        return 32 - result;
    }

    public static boolean isValidIp(String ip) {
        return RegexUtil.IPV4_PATTERN.matcher(ip).matches();
    }

    public static boolean isValidNetMask(String netMask) {
        if (!Ipv4Util.isValidIp(netMask)) {
            return false;
        }
        long num = Ipv4Util.ip2Num(netMask);
        return (num - 1L | num) == 0xFFFFFFFFL;
    }

    public static long ip2Num(String ip) {
        long result = 0L;
        String[] split = ip.split("\\.");
        for (int i = 3; i >= 0; --i) {
            long ipSeg = Long.parseLong(split[3 - i]);
            result |= ipSeg << i * 8;
        }
        return result;
    }

    public static String num2Ip(long num) {
        return (num >> 24 & 0xFFL) + "." + (num >> 16 & 0xFFL) + "." + (num >> 8 & 0xFFL) + "." + (num & 0xFFL);
    }
}

