/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.util;

import com.github.shoothzj.javatool.module.OperationSystem;
import com.github.shoothzj.javatool.util.EnvUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsUtil {
    private static final Logger log = LoggerFactory.getLogger(OsUtil.class);

    public static OperationSystem getOs() {
        String osName = EnvUtil.getOsName();
        if (osName.startsWith("Mac")) {
            return OperationSystem.MAC;
        }
        if (osName.startsWith("Windows")) {
            return OperationSystem.WINDOWS;
        }
        if (osName.startsWith("Linux")) {
            return OperationSystem.LINUX;
        }
        return OperationSystem.UNKNOWN;
    }

    public static String getDocumentPath() {
        OperationSystem operationSystem = OsUtil.getOs();
        if (operationSystem.equals((Object)OperationSystem.MAC) || operationSystem.equals((Object)OperationSystem.WINDOWS)) {
            return EnvUtil.getUserHome() + "/Documents";
        }
        return EnvUtil.getUserHome() + "/Documents";
    }
}

