/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.util;

import com.github.shoothzj.javatool.module.ShellResult;
import com.github.shoothzj.javatool.util.IoUtil;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellUtil {
    private static final Logger log = LoggerFactory.getLogger(ShellUtil.class);

    public static ShellResult executeScript(String script) {
        return ShellUtil.executeCmd("bash -x " + script);
    }

    public static ShellResult executeCmd(String[] cmd) {
        log.info("exec command array {}", (Object)String.join((CharSequence)";", cmd));
        String inputContent = "";
        String errorContent = "";
        int ret = -1;
        try {
            Process pid = Runtime.getRuntime().exec(cmd);
            ret = pid.waitFor();
            InputStream inputStream = pid.getInputStream();
            InputStream errorStream = pid.getErrorStream();
            inputContent = IoUtil.read2String(inputStream);
            errorContent = IoUtil.read2String(errorStream);
            log.error("command is {}, result is {}, input content is [{}], error content is [{}]", new Object[]{cmd, ret, inputContent, errorContent});
            return new ShellResult(ret, inputContent, errorContent);
        }
        catch (Exception e) {
            log.error("Execute command exception. [{}], input content is [{}], error content is [{}]", new Object[]{e.getMessage(), inputContent, errorContent});
            return new ShellResult(ret, inputContent, errorContent, e);
        }
    }

    public static ShellResult executeCmd(String cmd) {
        log.info("exec command {}", (Object)cmd);
        String inputContent = "";
        String errorContent = "";
        int ret = -1;
        try {
            Process pid = Runtime.getRuntime().exec(cmd);
            ret = pid.waitFor();
            InputStream inputStream = pid.getInputStream();
            InputStream errorStream = pid.getErrorStream();
            inputContent = IoUtil.read2String(inputStream);
            errorContent = IoUtil.read2String(errorStream);
            log.error("command is {}, result is {}, input content is [{}], error content is [{}]", new Object[]{cmd, ret, inputContent, errorContent});
            return new ShellResult(ret, inputContent, errorContent);
        }
        catch (Exception e) {
            log.error("Execute command exception. [{}], input content is [{}], error content is [{}]", new Object[]{e.getMessage(), inputContent, errorContent});
            return new ShellResult(ret, inputContent, errorContent, e);
        }
    }
}

