package com.github.shoothzj.javatool.module;

/**
 * @author hezhangjian
 */
public class ShellResult {
    private int returnCode;
    private String inputContent;
    private String errorContent;
    private Exception error;

    public ShellResult() {
    }

    public ShellResult(String inputContent, String errorContent) {
        this(0, inputContent, errorContent);
    }

    public ShellResult(int returnCode, String inputContent, String errorContent) {
        this(returnCode, inputContent, errorContent, null);
    }

    public ShellResult(int returnCode, String inputContent, String errorContent, Exception error) {
        this.returnCode = returnCode;
        this.inputContent = inputContent;
        this.errorContent = errorContent;
        this.error = error;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getInputContent() {
        return this.inputContent;
    }

    public String getErrorContent() {
        return this.errorContent;
    }

    public Exception getError() {
        return this.error;
    }

    public void setReturnCode(final int returnCode) {
        this.returnCode = returnCode;
    }

    public void setInputContent(final String inputContent) {
        this.inputContent = inputContent;
    }

    public void setErrorContent(final String errorContent) {
        this.errorContent = errorContent;
    }

    public void setError(final Exception error) {
        this.error = error;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof ShellResult)) return false;
        final ShellResult other = (ShellResult) o;
        if (!other.canEqual((Object) this)) return false;
        if (this.getReturnCode() != other.getReturnCode()) return false;
        final Object this$inputContent = this.getInputContent();
        final Object other$inputContent = other.getInputContent();
        if (this$inputContent == null ? other$inputContent != null : !this$inputContent.equals(other$inputContent)) return false;
        final Object this$errorContent = this.getErrorContent();
        final Object other$errorContent = other.getErrorContent();
        if (this$errorContent == null ? other$errorContent != null : !this$errorContent.equals(other$errorContent)) return false;
        final Object this$error = this.getError();
        final Object other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) return false;
        return true;
    }

    protected boolean canEqual(final Object other) {
        return other instanceof ShellResult;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getReturnCode();
        final Object $inputContent = this.getInputContent();
        result = result * PRIME + ($inputContent == null ? 43 : $inputContent.hashCode());
        final Object $errorContent = this.getErrorContent();
        result = result * PRIME + ($errorContent == null ? 43 : $errorContent.hashCode());
        final Object $error = this.getError();
        result = result * PRIME + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ShellResult(returnCode=" + this.getReturnCode() + ", inputContent=" + this.getInputContent() + ", errorContent=" + this.getErrorContent() + ", error=" + this.getError() + ")";
    }
}
