package com.github.shoothzj.javatool.config;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

/**
 * @author hezhangjian
 */
public class ConfigProperties {
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ConfigProperties.class);
    private final Properties properties;
    private final String dstFileName;

    public ConfigProperties(String originFile, String dstFileName) {
        properties = new Properties();
        try (FileInputStream fis = new FileInputStream(originFile)) {
            properties.load(fis);
        } catch (Exception e) {
            throw new IllegalStateException("read properties from file failed ", e);
        }
        this.dstFileName = dstFileName;
    }

    public void set(String key, String value) {
        properties.setProperty(key, value);
    }

    public void write() {
        try (FileOutputStream fos = new FileOutputStream(dstFileName)) {
            properties.store(fos, "");
        } catch (Exception e) {
            throw new IllegalStateException("write config file failed ", e);
        }
    }
}
